/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StartingAfterPaging {
    private final int perPage;
    private final Optional<String> startingAfter;
    private final Map<String, Object> additionalProperties;

    private StartingAfterPaging(int perPage, Optional<String> startingAfter, Map<String, Object> additionalProperties) {
        this.perPage = perPage;
        this.startingAfter = startingAfter;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="per_page")
    public int getPerPage() {
        return this.perPage;
    }

    @JsonProperty(value="starting_after")
    public Optional<String> getStartingAfter() {
        return this.startingAfter;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StartingAfterPaging && this.equalTo((StartingAfterPaging)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StartingAfterPaging other) {
        return this.perPage == other.perPage && this.startingAfter.equals(other.startingAfter);
    }

    public int hashCode() {
        return Objects.hash(this.perPage, this.startingAfter);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PerPageStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PerPageStage,
    _FinalStage {
        private int perPage;
        private Optional<String> startingAfter = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(StartingAfterPaging other) {
            this.perPage(other.getPerPage());
            this.startingAfter(other.getStartingAfter());
            return this;
        }

        @Override
        @JsonSetter(value="per_page")
        public _FinalStage perPage(int perPage) {
            this.perPage = perPage;
            return this;
        }

        @Override
        public _FinalStage startingAfter(String startingAfter) {
            this.startingAfter = Optional.ofNullable(startingAfter);
            return this;
        }

        @Override
        @JsonSetter(value="starting_after", nulls=Nulls.SKIP)
        public _FinalStage startingAfter(Optional<String> startingAfter) {
            this.startingAfter = startingAfter;
            return this;
        }

        @Override
        public StartingAfterPaging build() {
            return new StartingAfterPaging(this.perPage, this.startingAfter, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public StartingAfterPaging build();

        public _FinalStage startingAfter(Optional<String> var1);

        public _FinalStage startingAfter(String var1);
    }

    public static interface PerPageStage {
        public _FinalStage perPage(int var1);

        public Builder from(StartingAfterPaging var1);
    }
}

