/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.tickets.types.Ticket;
import com.intercom.api.types.CursorPages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketList {
    private final List<Ticket> tickets;
    private final int totalCount;
    private final Optional<CursorPages> pages;
    private final Map<String, Object> additionalProperties;

    private TicketList(List<Ticket> tickets, int totalCount, Optional<CursorPages> pages, Map<String, Object> additionalProperties) {
        this.tickets = tickets;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "ticket.list";
    }

    @JsonProperty(value="tickets")
    public List<Ticket> getTickets() {
        return this.tickets;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="pages")
    public Optional<CursorPages> getPages() {
        return this.pages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketList && this.equalTo((TicketList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketList other) {
        return this.tickets.equals(other.tickets) && this.totalCount == other.totalCount && this.pages.equals(other.pages);
    }

    public int hashCode() {
        return Objects.hash(this.tickets, this.totalCount, this.pages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    _FinalStage {
        private int totalCount;
        private Optional<CursorPages> pages = Optional.empty();
        private List<Ticket> tickets = new ArrayList<Ticket>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TicketList other) {
            this.tickets(other.getTickets());
            this.totalCount(other.getTotalCount());
            this.pages(other.getPages());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @Override
        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public _FinalStage pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        @Override
        public _FinalStage addAllTickets(List<Ticket> tickets) {
            this.tickets.addAll(tickets);
            return this;
        }

        @Override
        public _FinalStage addTickets(Ticket tickets) {
            this.tickets.add(tickets);
            return this;
        }

        @Override
        @JsonSetter(value="tickets", nulls=Nulls.SKIP)
        public _FinalStage tickets(List<Ticket> tickets) {
            this.tickets.clear();
            this.tickets.addAll(tickets);
            return this;
        }

        @Override
        public TicketList build() {
            return new TicketList(this.tickets, this.totalCount, this.pages, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TicketList build();

        public _FinalStage tickets(List<Ticket> var1);

        public _FinalStage addTickets(Ticket var1);

        public _FinalStage addAllTickets(List<Ticket> var1);

        public _FinalStage pages(Optional<CursorPages> var1);

        public _FinalStage pages(CursorPages var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);

        public Builder from(TicketList var1);
    }
}

