/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using=Deserializer.class)
public final class UpdateVisitorRequest {
    private final Object value;
    private final int type;

    private UpdateVisitorRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((WithId)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((WithUserId)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateVisitorRequest && this.equalTo((UpdateVisitorRequest)other);
    }

    private boolean equalTo(UpdateVisitorRequest other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static UpdateVisitorRequest of(WithId value) {
        return new UpdateVisitorRequest(value, 0);
    }

    public static UpdateVisitorRequest of(WithUserId value) {
        return new UpdateVisitorRequest(value, 1);
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class WithId {
        private final String id;
        private final Optional<String> name;
        private final Optional<Map<String, String>> customAttributes;
        private final Map<String, Object> additionalProperties;

        private WithId(String id, Optional<String> name, Optional<Map<String, String>> customAttributes, Map<String, Object> additionalProperties) {
            this.id = id;
            this.name = name;
            this.customAttributes = customAttributes;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="id")
        public String getId() {
            return this.id;
        }

        @JsonProperty(value="name")
        public Optional<String> getName() {
            return this.name;
        }

        @JsonProperty(value="custom_attributes")
        public Optional<Map<String, String>> getCustomAttributes() {
            return this.customAttributes;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof WithId && this.equalTo((WithId)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithId other) {
            return this.id.equals(other.id) && this.name.equals(other.name) && this.customAttributes.equals(other.customAttributes);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.customAttributes);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static IdStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements IdStage,
        _FinalStage {
            private String id;
            private Optional<Map<String, String>> customAttributes = Optional.empty();
            private Optional<String> name = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(WithId other) {
                this.id(other.getId());
                this.name(other.getName());
                this.customAttributes(other.getCustomAttributes());
                return this;
            }

            @Override
            @JsonSetter(value="id")
            public _FinalStage id(@NotNull String id) {
                this.id = Objects.requireNonNull(id, "id must not be null");
                return this;
            }

            @Override
            public _FinalStage customAttributes(Map<String, String> customAttributes) {
                this.customAttributes = Optional.ofNullable(customAttributes);
                return this;
            }

            @Override
            @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
            public _FinalStage customAttributes(Optional<Map<String, String>> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            @Override
            public _FinalStage name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            @Override
            @JsonSetter(value="name", nulls=Nulls.SKIP)
            public _FinalStage name(Optional<String> name) {
                this.name = name;
                return this;
            }

            @Override
            public WithId build() {
                return new WithId(this.id, this.name, this.customAttributes, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public WithId build();

            public _FinalStage name(Optional<String> var1);

            public _FinalStage name(String var1);

            public _FinalStage customAttributes(Optional<Map<String, String>> var1);

            public _FinalStage customAttributes(Map<String, String> var1);
        }

        public static interface IdStage {
            public _FinalStage id(@NotNull String var1);

            public Builder from(WithId var1);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class WithUserId {
        private final String userId;
        private final Optional<String> name;
        private final Optional<Map<String, String>> customAttributes;
        private final Map<String, Object> additionalProperties;

        private WithUserId(String userId, Optional<String> name, Optional<Map<String, String>> customAttributes, Map<String, Object> additionalProperties) {
            this.userId = userId;
            this.name = name;
            this.customAttributes = customAttributes;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="user_id")
        public String getUserId() {
            return this.userId;
        }

        @JsonProperty(value="name")
        public Optional<String> getName() {
            return this.name;
        }

        @JsonProperty(value="custom_attributes")
        public Optional<Map<String, String>> getCustomAttributes() {
            return this.customAttributes;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof WithUserId && this.equalTo((WithUserId)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithUserId other) {
            return this.userId.equals(other.userId) && this.name.equals(other.name) && this.customAttributes.equals(other.customAttributes);
        }

        public int hashCode() {
            return Objects.hash(this.userId, this.name, this.customAttributes);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static UserIdStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements UserIdStage,
        _FinalStage {
            private String userId;
            private Optional<Map<String, String>> customAttributes = Optional.empty();
            private Optional<String> name = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(WithUserId other) {
                this.userId(other.getUserId());
                this.name(other.getName());
                this.customAttributes(other.getCustomAttributes());
                return this;
            }

            @Override
            @JsonSetter(value="user_id")
            public _FinalStage userId(@NotNull String userId) {
                this.userId = Objects.requireNonNull(userId, "userId must not be null");
                return this;
            }

            @Override
            public _FinalStage customAttributes(Map<String, String> customAttributes) {
                this.customAttributes = Optional.ofNullable(customAttributes);
                return this;
            }

            @Override
            @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
            public _FinalStage customAttributes(Optional<Map<String, String>> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            @Override
            public _FinalStage name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            @Override
            @JsonSetter(value="name", nulls=Nulls.SKIP)
            public _FinalStage name(Optional<String> name) {
                this.name = name;
                return this;
            }

            @Override
            public WithUserId build() {
                return new WithUserId(this.userId, this.name, this.customAttributes, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public WithUserId build();

            public _FinalStage name(Optional<String> var1);

            public _FinalStage name(String var1);

            public _FinalStage customAttributes(Optional<Map<String, String>> var1);

            public _FinalStage customAttributes(Map<String, String> var1);
        }

        public static interface UserIdStage {
            public _FinalStage userId(@NotNull String var1);

            public Builder from(WithUserId var1);
        }
    }

    static final class Deserializer
    extends StdDeserializer<UpdateVisitorRequest> {
        Deserializer() {
            super(UpdateVisitorRequest.class);
        }

        public UpdateVisitorRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return UpdateVisitorRequest.of((WithId)ObjectMappers.JSON_MAPPER.convertValue(value, WithId.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return UpdateVisitorRequest.of((WithUserId)ObjectMappers.JSON_MAPPER.convertValue(value, WithUserId.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(WithId var1);

        public T visit(WithUserId var1);
    }
}

