/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DetachSubscriptionFromContactRequest {
    private final String contactId;
    private final String subscriptionId;
    private final Map<String, Object> additionalProperties;

    private DetachSubscriptionFromContactRequest(String contactId, String subscriptionId, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.subscriptionId = subscriptionId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="contact_id")
    public String getContactId() {
        return this.contactId;
    }

    @JsonProperty(value="subscription_id")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DetachSubscriptionFromContactRequest && this.equalTo((DetachSubscriptionFromContactRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DetachSubscriptionFromContactRequest other) {
        return this.contactId.equals(other.contactId) && this.subscriptionId.equals(other.subscriptionId);
    }

    public int hashCode() {
        return Objects.hash(this.contactId, this.subscriptionId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ContactIdStage,
    SubscriptionIdStage,
    _FinalStage {
        private String contactId;
        private String subscriptionId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DetachSubscriptionFromContactRequest other) {
            this.contactId(other.getContactId());
            this.subscriptionId(other.getSubscriptionId());
            return this;
        }

        @Override
        @JsonSetter(value="contact_id")
        public SubscriptionIdStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="subscription_id")
        public _FinalStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @Override
        public DetachSubscriptionFromContactRequest build() {
            return new DetachSubscriptionFromContactRequest(this.contactId, this.subscriptionId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DetachSubscriptionFromContactRequest build();
    }

    public static interface SubscriptionIdStage {
        public _FinalStage subscriptionId(@NotNull String var1);
    }

    public static interface ContactIdStage {
        public SubscriptionIdStage contactId(@NotNull String var1);

        public Builder from(DetachSubscriptionFromContactRequest var1);
    }
}

