/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.events.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListEventSummariesRequest {
    private final Optional<String> userId;
    private final Optional<EventSummaries> eventSummaries;
    private final Map<String, Object> additionalProperties;

    private ListEventSummariesRequest(Optional<String> userId, Optional<EventSummaries> eventSummaries, Map<String, Object> additionalProperties) {
        this.userId = userId;
        this.eventSummaries = eventSummaries;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="event_summaries")
    public Optional<EventSummaries> getEventSummaries() {
        return this.eventSummaries;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListEventSummariesRequest && this.equalTo((ListEventSummariesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEventSummariesRequest other) {
        return this.userId.equals(other.userId) && this.eventSummaries.equals(other.eventSummaries);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.eventSummaries);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class EventSummaries {
        private final Optional<String> eventName;
        private final Optional<Integer> count;
        private final Optional<Integer> first;
        private final Optional<Integer> last;
        private final Map<String, Object> additionalProperties;

        private EventSummaries(Optional<String> eventName, Optional<Integer> count, Optional<Integer> first, Optional<Integer> last, Map<String, Object> additionalProperties) {
            this.eventName = eventName;
            this.count = count;
            this.first = first;
            this.last = last;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="event_name")
        public Optional<String> getEventName() {
            return this.eventName;
        }

        @JsonProperty(value="count")
        public Optional<Integer> getCount() {
            return this.count;
        }

        @JsonProperty(value="first")
        public Optional<Integer> getFirst() {
            return this.first;
        }

        @JsonProperty(value="last")
        public Optional<Integer> getLast() {
            return this.last;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof EventSummaries && this.equalTo((EventSummaries)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(EventSummaries other) {
            return this.eventName.equals(other.eventName) && this.count.equals(other.count) && this.first.equals(other.first) && this.last.equals(other.last);
        }

        public int hashCode() {
            return Objects.hash(this.eventName, this.count, this.first, this.last);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> eventName = Optional.empty();
            private Optional<Integer> count = Optional.empty();
            private Optional<Integer> first = Optional.empty();
            private Optional<Integer> last = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(EventSummaries other) {
                this.eventName(other.getEventName());
                this.count(other.getCount());
                this.first(other.getFirst());
                this.last(other.getLast());
                return this;
            }

            @JsonSetter(value="event_name", nulls=Nulls.SKIP)
            public Builder eventName(Optional<String> eventName) {
                this.eventName = eventName;
                return this;
            }

            public Builder eventName(String eventName) {
                this.eventName = Optional.ofNullable(eventName);
                return this;
            }

            @JsonSetter(value="count", nulls=Nulls.SKIP)
            public Builder count(Optional<Integer> count) {
                this.count = count;
                return this;
            }

            public Builder count(Integer count) {
                this.count = Optional.ofNullable(count);
                return this;
            }

            @JsonSetter(value="first", nulls=Nulls.SKIP)
            public Builder first(Optional<Integer> first) {
                this.first = first;
                return this;
            }

            public Builder first(Integer first) {
                this.first = Optional.ofNullable(first);
                return this;
            }

            @JsonSetter(value="last", nulls=Nulls.SKIP)
            public Builder last(Optional<Integer> last) {
                this.last = last;
                return this;
            }

            public Builder last(Integer last) {
                this.last = Optional.ofNullable(last);
                return this;
            }

            public EventSummaries build() {
                return new EventSummaries(this.eventName, this.count, this.first, this.last, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> userId = Optional.empty();
        private Optional<EventSummaries> eventSummaries = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListEventSummariesRequest other) {
            this.userId(other.getUserId());
            this.eventSummaries(other.getEventSummaries());
            return this;
        }

        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @JsonSetter(value="event_summaries", nulls=Nulls.SKIP)
        public Builder eventSummaries(Optional<EventSummaries> eventSummaries) {
            this.eventSummaries = eventSummaries;
            return this;
        }

        public Builder eventSummaries(EventSummaries eventSummaries) {
            this.eventSummaries = Optional.ofNullable(eventSummaries);
            return this;
        }

        public ListEventSummariesRequest build() {
            return new ListEventSummariesRequest(this.userId, this.eventSummaries, this.additionalProperties);
        }
    }
}

