/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RetrieveConversationRequest {
    private final int id;
    private final Optional<String> displayAs;
    private final Optional<Boolean> includeTranslations;
    private final Map<String, Object> additionalProperties;

    private RetrieveConversationRequest(int id, Optional<String> displayAs, Optional<Boolean> includeTranslations, Map<String, Object> additionalProperties) {
        this.id = id;
        this.displayAs = displayAs;
        this.includeTranslations = includeTranslations;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public int getId() {
        return this.id;
    }

    @JsonProperty(value="display_as")
    public Optional<String> getDisplayAs() {
        return this.displayAs;
    }

    @JsonProperty(value="include_translations")
    public Optional<Boolean> getIncludeTranslations() {
        return this.includeTranslations;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RetrieveConversationRequest && this.equalTo((RetrieveConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RetrieveConversationRequest other) {
        return this.id == other.id && this.displayAs.equals(other.displayAs) && this.includeTranslations.equals(other.includeTranslations);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayAs, this.includeTranslations);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private int id;
        private Optional<Boolean> includeTranslations = Optional.empty();
        private Optional<String> displayAs = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RetrieveConversationRequest other) {
            this.id(other.getId());
            this.displayAs(other.getDisplayAs());
            this.includeTranslations(other.getIncludeTranslations());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(int id) {
            this.id = id;
            return this;
        }

        @Override
        public _FinalStage includeTranslations(Boolean includeTranslations) {
            this.includeTranslations = Optional.ofNullable(includeTranslations);
            return this;
        }

        @Override
        @JsonSetter(value="include_translations", nulls=Nulls.SKIP)
        public _FinalStage includeTranslations(Optional<Boolean> includeTranslations) {
            this.includeTranslations = includeTranslations;
            return this;
        }

        @Override
        public _FinalStage displayAs(String displayAs) {
            this.displayAs = Optional.ofNullable(displayAs);
            return this;
        }

        @Override
        @JsonSetter(value="display_as", nulls=Nulls.SKIP)
        public _FinalStage displayAs(Optional<String> displayAs) {
            this.displayAs = displayAs;
            return this;
        }

        @Override
        public RetrieveConversationRequest build() {
            return new RetrieveConversationRequest(this.id, this.displayAs, this.includeTranslations, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RetrieveConversationRequest build();

        public _FinalStage displayAs(Optional<String> var1);

        public _FinalStage displayAs(String var1);

        public _FinalStage includeTranslations(Optional<Boolean> var1);

        public _FinalStage includeTranslations(Boolean var1);
    }

    public static interface IdStage {
        public _FinalStage id(int var1);

        public Builder from(RetrieveConversationRequest var1);
    }
}

