/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.helpcenter;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.helpcenter.RawHelpCenterClient;
import com.intercom.api.resources.unstable.helpcenter.requests.CreateCollectionRequest;
import com.intercom.api.resources.unstable.helpcenter.requests.DeleteCollectionRequest;
import com.intercom.api.resources.unstable.helpcenter.requests.RetrieveCollectionRequest;
import com.intercom.api.resources.unstable.helpcenter.requests.RetrieveHelpCenterRequest;
import com.intercom.api.resources.unstable.helpcenter.requests.UpdateCollectionRequest;
import com.intercom.api.resources.unstable.helpcenter.types.Collection;
import com.intercom.api.resources.unstable.helpcenter.types.HelpCenter;
import com.intercom.api.resources.unstable.helpcenter.types.HelpCenterList;
import com.intercom.api.resources.unstable.types.CollectionList;
import com.intercom.api.resources.unstable.types.DeletedCollectionObject;

public class HelpCenterClient {
    protected final ClientOptions clientOptions;
    private final RawHelpCenterClient rawClient;

    public HelpCenterClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawHelpCenterClient(clientOptions);
    }

    public RawHelpCenterClient withRawResponse() {
        return this.rawClient;
    }

    public CollectionList listAllCollections() {
        return this.rawClient.listAllCollections().body();
    }

    public CollectionList listAllCollections(RequestOptions requestOptions) {
        return this.rawClient.listAllCollections(requestOptions).body();
    }

    public Collection createCollection(CreateCollectionRequest request) {
        return this.rawClient.createCollection(request).body();
    }

    public Collection createCollection(CreateCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.createCollection(request, requestOptions).body();
    }

    public Collection retrieveCollection(RetrieveCollectionRequest request) {
        return this.rawClient.retrieveCollection(request).body();
    }

    public Collection retrieveCollection(RetrieveCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveCollection(request, requestOptions).body();
    }

    public Collection updateCollection(UpdateCollectionRequest request) {
        return this.rawClient.updateCollection(request).body();
    }

    public Collection updateCollection(UpdateCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateCollection(request, requestOptions).body();
    }

    public DeletedCollectionObject deleteCollection(DeleteCollectionRequest request) {
        return this.rawClient.deleteCollection(request).body();
    }

    public DeletedCollectionObject deleteCollection(DeleteCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteCollection(request, requestOptions).body();
    }

    public HelpCenter retrieveHelpCenter(RetrieveHelpCenterRequest request) {
        return this.rawClient.retrieveHelpCenter(request).body();
    }

    public HelpCenter retrieveHelpCenter(RetrieveHelpCenterRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveHelpCenter(request, requestOptions).body();
    }

    public HelpCenterList listHelpCenters() {
        return this.rawClient.listHelpCenters().body();
    }

    public HelpCenterList listHelpCenters(RequestOptions requestOptions) {
        return this.rawClient.listHelpCenters(requestOptions).body();
    }
}

