/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.subscriptiontypes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AttachSubscriptionTypeToContactRequest {
    private final String contactId;
    private final String id;
    private final String consentType;
    private final Map<String, Object> additionalProperties;

    private AttachSubscriptionTypeToContactRequest(String contactId, String id, String consentType, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.id = id;
        this.consentType = consentType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="contact_id")
    public String getContactId() {
        return this.contactId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="consent_type")
    public String getConsentType() {
        return this.consentType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AttachSubscriptionTypeToContactRequest && this.equalTo((AttachSubscriptionTypeToContactRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AttachSubscriptionTypeToContactRequest other) {
        return this.contactId.equals(other.contactId) && this.id.equals(other.id) && this.consentType.equals(other.consentType);
    }

    public int hashCode() {
        return Objects.hash(this.contactId, this.id, this.consentType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ContactIdStage,
    IdStage,
    ConsentTypeStage,
    _FinalStage {
        private String contactId;
        private String id;
        private String consentType;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AttachSubscriptionTypeToContactRequest other) {
            this.contactId(other.getContactId());
            this.id(other.getId());
            this.consentType(other.getConsentType());
            return this;
        }

        @Override
        @JsonSetter(value="contact_id")
        public IdStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ConsentTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="consent_type")
        public _FinalStage consentType(@NotNull String consentType) {
            this.consentType = Objects.requireNonNull(consentType, "consentType must not be null");
            return this;
        }

        @Override
        public AttachSubscriptionTypeToContactRequest build() {
            return new AttachSubscriptionTypeToContactRequest(this.contactId, this.id, this.consentType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AttachSubscriptionTypeToContactRequest build();
    }

    public static interface ConsentTypeStage {
        public _FinalStage consentType(@NotNull String var1);
    }

    public static interface IdStage {
        public ConsentTypeStage id(@NotNull String var1);
    }

    public static interface ContactIdStage {
        public IdStage contactId(@NotNull String var1);

        public Builder from(AttachSubscriptionTypeToContactRequest var1);
    }
}

