/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.tags.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.Reference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Tag {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<Integer> appliedAt;
    private final Optional<Reference> appliedBy;
    private final Map<String, Object> additionalProperties;

    private Tag(Optional<String> type, Optional<String> id, Optional<String> name, Optional<Integer> appliedAt, Optional<Reference> appliedBy, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.appliedAt = appliedAt;
        this.appliedBy = appliedBy;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="applied_at")
    public Optional<Integer> getAppliedAt() {
        return this.appliedAt;
    }

    @JsonProperty(value="applied_by")
    public Optional<Reference> getAppliedBy() {
        return this.appliedBy;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Tag && this.equalTo((Tag)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Tag other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name) && this.appliedAt.equals(other.appliedAt) && this.appliedBy.equals(other.appliedBy);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.appliedAt, this.appliedBy);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<Integer> appliedAt = Optional.empty();
        private Optional<Reference> appliedBy = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Tag other) {
            this.type(other.getType());
            this.id(other.getId());
            this.name(other.getName());
            this.appliedAt(other.getAppliedAt());
            this.appliedBy(other.getAppliedBy());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="applied_at", nulls=Nulls.SKIP)
        public Builder appliedAt(Optional<Integer> appliedAt) {
            this.appliedAt = appliedAt;
            return this;
        }

        public Builder appliedAt(Integer appliedAt) {
            this.appliedAt = Optional.ofNullable(appliedAt);
            return this;
        }

        @JsonSetter(value="applied_by", nulls=Nulls.SKIP)
        public Builder appliedBy(Optional<Reference> appliedBy) {
            this.appliedBy = appliedBy;
            return this;
        }

        public Builder appliedBy(Reference appliedBy) {
            this.appliedBy = Optional.ofNullable(appliedBy);
            return this;
        }

        public Tag build() {
            return new Tag(this.type, this.id, this.name, this.appliedAt, this.appliedBy, this.additionalProperties);
        }
    }
}

