/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.tickettypeattributes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateTicketTypeAttributeRequest {
    private final String ticketTypeId;
    private final String name;
    private final String description;
    private final DataType dataType;
    private final Optional<Boolean> requiredToCreate;
    private final Optional<Boolean> requiredToCreateForContacts;
    private final Optional<Boolean> visibleOnCreate;
    private final Optional<Boolean> visibleToContacts;
    private final Optional<Boolean> multiline;
    private final Optional<String> listItems;
    private final Optional<Boolean> allowMultipleValues;
    private final Map<String, Object> additionalProperties;

    private CreateTicketTypeAttributeRequest(String ticketTypeId, String name, String description, DataType dataType, Optional<Boolean> requiredToCreate, Optional<Boolean> requiredToCreateForContacts, Optional<Boolean> visibleOnCreate, Optional<Boolean> visibleToContacts, Optional<Boolean> multiline, Optional<String> listItems, Optional<Boolean> allowMultipleValues, Map<String, Object> additionalProperties) {
        this.ticketTypeId = ticketTypeId;
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.requiredToCreate = requiredToCreate;
        this.requiredToCreateForContacts = requiredToCreateForContacts;
        this.visibleOnCreate = visibleOnCreate;
        this.visibleToContacts = visibleToContacts;
        this.multiline = multiline;
        this.listItems = listItems;
        this.allowMultipleValues = allowMultipleValues;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ticket_type_id")
    public String getTicketTypeId() {
        return this.ticketTypeId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="data_type")
    public DataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="required_to_create")
    public Optional<Boolean> getRequiredToCreate() {
        return this.requiredToCreate;
    }

    @JsonProperty(value="required_to_create_for_contacts")
    public Optional<Boolean> getRequiredToCreateForContacts() {
        return this.requiredToCreateForContacts;
    }

    @JsonProperty(value="visible_on_create")
    public Optional<Boolean> getVisibleOnCreate() {
        return this.visibleOnCreate;
    }

    @JsonProperty(value="visible_to_contacts")
    public Optional<Boolean> getVisibleToContacts() {
        return this.visibleToContacts;
    }

    @JsonProperty(value="multiline")
    public Optional<Boolean> getMultiline() {
        return this.multiline;
    }

    @JsonProperty(value="list_items")
    public Optional<String> getListItems() {
        return this.listItems;
    }

    @JsonProperty(value="allow_multiple_values")
    public Optional<Boolean> getAllowMultipleValues() {
        return this.allowMultipleValues;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateTicketTypeAttributeRequest && this.equalTo((CreateTicketTypeAttributeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateTicketTypeAttributeRequest other) {
        return this.ticketTypeId.equals(other.ticketTypeId) && this.name.equals(other.name) && this.description.equals(other.description) && this.dataType.equals(other.dataType) && this.requiredToCreate.equals(other.requiredToCreate) && this.requiredToCreateForContacts.equals(other.requiredToCreateForContacts) && this.visibleOnCreate.equals(other.visibleOnCreate) && this.visibleToContacts.equals(other.visibleToContacts) && this.multiline.equals(other.multiline) && this.listItems.equals(other.listItems) && this.allowMultipleValues.equals(other.allowMultipleValues);
    }

    public int hashCode() {
        return Objects.hash(this.ticketTypeId, this.name, this.description, this.dataType, this.requiredToCreate, this.requiredToCreateForContacts, this.visibleOnCreate, this.visibleToContacts, this.multiline, this.listItems, this.allowMultipleValues);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketTypeIdStage builder() {
        return new Builder();
    }

    public static final class DataType {
        public static final DataType STRING = new DataType(Value.STRING, "string");
        public static final DataType DECIMAL = new DataType(Value.DECIMAL, "decimal");
        public static final DataType LIST = new DataType(Value.LIST, "list");
        public static final DataType INTEGER = new DataType(Value.INTEGER, "integer");
        public static final DataType DATETIME = new DataType(Value.DATETIME, "datetime");
        public static final DataType BOOLEAN = new DataType(Value.BOOLEAN, "boolean");
        public static final DataType FILES = new DataType(Value.FILES, "files");
        private final Value value;
        private final String string;

        DataType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof DataType && this.string.equals(((DataType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case STRING: {
                    return visitor.visitString();
                }
                case DECIMAL: {
                    return visitor.visitDecimal();
                }
                case LIST: {
                    return visitor.visitList();
                }
                case INTEGER: {
                    return visitor.visitInteger();
                }
                case DATETIME: {
                    return visitor.visitDatetime();
                }
                case BOOLEAN: {
                    return visitor.visitBoolean();
                }
                case FILES: {
                    return visitor.visitFiles();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static DataType valueOf(String value) {
            switch (value) {
                case "string": {
                    return STRING;
                }
                case "decimal": {
                    return DECIMAL;
                }
                case "list": {
                    return LIST;
                }
                case "integer": {
                    return INTEGER;
                }
                case "datetime": {
                    return DATETIME;
                }
                case "boolean": {
                    return BOOLEAN;
                }
                case "files": {
                    return FILES;
                }
            }
            return new DataType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitString();

            public T visitList();

            public T visitInteger();

            public T visitDecimal();

            public T visitBoolean();

            public T visitDatetime();

            public T visitFiles();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            STRING,
            LIST,
            INTEGER,
            DECIMAL,
            BOOLEAN,
            DATETIME,
            FILES,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TicketTypeIdStage,
    NameStage,
    DescriptionStage,
    DataTypeStage,
    _FinalStage {
        private String ticketTypeId;
        private String name;
        private String description;
        private DataType dataType;
        private Optional<Boolean> allowMultipleValues = Optional.empty();
        private Optional<String> listItems = Optional.empty();
        private Optional<Boolean> multiline = Optional.empty();
        private Optional<Boolean> visibleToContacts = Optional.empty();
        private Optional<Boolean> visibleOnCreate = Optional.empty();
        private Optional<Boolean> requiredToCreateForContacts = Optional.empty();
        private Optional<Boolean> requiredToCreate = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateTicketTypeAttributeRequest other) {
            this.ticketTypeId(other.getTicketTypeId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.dataType(other.getDataType());
            this.requiredToCreate(other.getRequiredToCreate());
            this.requiredToCreateForContacts(other.getRequiredToCreateForContacts());
            this.visibleOnCreate(other.getVisibleOnCreate());
            this.visibleToContacts(other.getVisibleToContacts());
            this.multiline(other.getMultiline());
            this.listItems(other.getListItems());
            this.allowMultipleValues(other.getAllowMultipleValues());
            return this;
        }

        @Override
        @JsonSetter(value="ticket_type_id")
        public NameStage ticketTypeId(@NotNull String ticketTypeId) {
            this.ticketTypeId = Objects.requireNonNull(ticketTypeId, "ticketTypeId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public DescriptionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public DataTypeStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="data_type")
        public _FinalStage dataType(@NotNull DataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType must not be null");
            return this;
        }

        @Override
        public _FinalStage allowMultipleValues(Boolean allowMultipleValues) {
            this.allowMultipleValues = Optional.ofNullable(allowMultipleValues);
            return this;
        }

        @Override
        @JsonSetter(value="allow_multiple_values", nulls=Nulls.SKIP)
        public _FinalStage allowMultipleValues(Optional<Boolean> allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            return this;
        }

        @Override
        public _FinalStage listItems(String listItems) {
            this.listItems = Optional.ofNullable(listItems);
            return this;
        }

        @Override
        @JsonSetter(value="list_items", nulls=Nulls.SKIP)
        public _FinalStage listItems(Optional<String> listItems) {
            this.listItems = listItems;
            return this;
        }

        @Override
        public _FinalStage multiline(Boolean multiline) {
            this.multiline = Optional.ofNullable(multiline);
            return this;
        }

        @Override
        @JsonSetter(value="multiline", nulls=Nulls.SKIP)
        public _FinalStage multiline(Optional<Boolean> multiline) {
            this.multiline = multiline;
            return this;
        }

        @Override
        public _FinalStage visibleToContacts(Boolean visibleToContacts) {
            this.visibleToContacts = Optional.ofNullable(visibleToContacts);
            return this;
        }

        @Override
        @JsonSetter(value="visible_to_contacts", nulls=Nulls.SKIP)
        public _FinalStage visibleToContacts(Optional<Boolean> visibleToContacts) {
            this.visibleToContacts = visibleToContacts;
            return this;
        }

        @Override
        public _FinalStage visibleOnCreate(Boolean visibleOnCreate) {
            this.visibleOnCreate = Optional.ofNullable(visibleOnCreate);
            return this;
        }

        @Override
        @JsonSetter(value="visible_on_create", nulls=Nulls.SKIP)
        public _FinalStage visibleOnCreate(Optional<Boolean> visibleOnCreate) {
            this.visibleOnCreate = visibleOnCreate;
            return this;
        }

        @Override
        public _FinalStage requiredToCreateForContacts(Boolean requiredToCreateForContacts) {
            this.requiredToCreateForContacts = Optional.ofNullable(requiredToCreateForContacts);
            return this;
        }

        @Override
        @JsonSetter(value="required_to_create_for_contacts", nulls=Nulls.SKIP)
        public _FinalStage requiredToCreateForContacts(Optional<Boolean> requiredToCreateForContacts) {
            this.requiredToCreateForContacts = requiredToCreateForContacts;
            return this;
        }

        @Override
        public _FinalStage requiredToCreate(Boolean requiredToCreate) {
            this.requiredToCreate = Optional.ofNullable(requiredToCreate);
            return this;
        }

        @Override
        @JsonSetter(value="required_to_create", nulls=Nulls.SKIP)
        public _FinalStage requiredToCreate(Optional<Boolean> requiredToCreate) {
            this.requiredToCreate = requiredToCreate;
            return this;
        }

        @Override
        public CreateTicketTypeAttributeRequest build() {
            return new CreateTicketTypeAttributeRequest(this.ticketTypeId, this.name, this.description, this.dataType, this.requiredToCreate, this.requiredToCreateForContacts, this.visibleOnCreate, this.visibleToContacts, this.multiline, this.listItems, this.allowMultipleValues, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateTicketTypeAttributeRequest build();

        public _FinalStage requiredToCreate(Optional<Boolean> var1);

        public _FinalStage requiredToCreate(Boolean var1);

        public _FinalStage requiredToCreateForContacts(Optional<Boolean> var1);

        public _FinalStage requiredToCreateForContacts(Boolean var1);

        public _FinalStage visibleOnCreate(Optional<Boolean> var1);

        public _FinalStage visibleOnCreate(Boolean var1);

        public _FinalStage visibleToContacts(Optional<Boolean> var1);

        public _FinalStage visibleToContacts(Boolean var1);

        public _FinalStage multiline(Optional<Boolean> var1);

        public _FinalStage multiline(Boolean var1);

        public _FinalStage listItems(Optional<String> var1);

        public _FinalStage listItems(String var1);

        public _FinalStage allowMultipleValues(Optional<Boolean> var1);

        public _FinalStage allowMultipleValues(Boolean var1);
    }

    public static interface DataTypeStage {
        public _FinalStage dataType(@NotNull DataType var1);
    }

    public static interface DescriptionStage {
        public DataTypeStage description(@NotNull String var1);
    }

    public static interface NameStage {
        public DescriptionStage name(@NotNull String var1);
    }

    public static interface TicketTypeIdStage {
        public NameStage ticketTypeId(@NotNull String var1);

        public Builder from(CreateTicketTypeAttributeRequest var1);
    }
}

