/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.workflows;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.types.WorkflowExport;
import com.intercom.api.resources.unstable.workflows.AsyncRawWorkflowsClient;
import com.intercom.api.resources.unstable.workflows.requests.ExportWorkflowRequest;
import java.util.concurrent.CompletableFuture;

public class AsyncWorkflowsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawWorkflowsClient rawClient;

    public AsyncWorkflowsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawWorkflowsClient(clientOptions);
    }

    public AsyncRawWorkflowsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<WorkflowExport> exportWorkflow(ExportWorkflowRequest request) {
        return this.rawClient.exportWorkflow(request).thenApply(response -> (WorkflowExport)response.body());
    }

    public CompletableFuture<WorkflowExport> exportWorkflow(ExportWorkflowRequest request, RequestOptions requestOptions) {
        return this.rawClient.exportWorkflow(request, requestOptions).thenApply(response -> (WorkflowExport)response.body());
    }
}

