/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class App {
    private final Optional<String> type;
    private final Optional<String> idCode;
    private final Optional<String> name;
    private final Optional<String> region;
    private final Optional<String> timezone;
    private final Optional<Integer> createdAt;
    private final Optional<Boolean> identityVerification;
    private final Map<String, Object> additionalProperties;

    private App(Optional<String> type, Optional<String> idCode, Optional<String> name, Optional<String> region, Optional<String> timezone, Optional<Integer> createdAt, Optional<Boolean> identityVerification, Map<String, Object> additionalProperties) {
        this.type = type;
        this.idCode = idCode;
        this.name = name;
        this.region = region;
        this.timezone = timezone;
        this.createdAt = createdAt;
        this.identityVerification = identityVerification;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id_code")
    public Optional<String> getIdCode() {
        return this.idCode;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="region")
    public Optional<String> getRegion() {
        return this.region;
    }

    @JsonProperty(value="timezone")
    public Optional<String> getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="identity_verification")
    public Optional<Boolean> getIdentityVerification() {
        return this.identityVerification;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof App && this.equalTo((App)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(App other) {
        return this.type.equals(other.type) && this.idCode.equals(other.idCode) && this.name.equals(other.name) && this.region.equals(other.region) && this.timezone.equals(other.timezone) && this.createdAt.equals(other.createdAt) && this.identityVerification.equals(other.identityVerification);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.idCode, this.name, this.region, this.timezone, this.createdAt, this.identityVerification);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> idCode = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> region = Optional.empty();
        private Optional<String> timezone = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Boolean> identityVerification = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(App other) {
            this.type(other.getType());
            this.idCode(other.getIdCode());
            this.name(other.getName());
            this.region(other.getRegion());
            this.timezone(other.getTimezone());
            this.createdAt(other.getCreatedAt());
            this.identityVerification(other.getIdentityVerification());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id_code", nulls=Nulls.SKIP)
        public Builder idCode(Optional<String> idCode) {
            this.idCode = idCode;
            return this;
        }

        public Builder idCode(String idCode) {
            this.idCode = Optional.ofNullable(idCode);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="region", nulls=Nulls.SKIP)
        public Builder region(Optional<String> region) {
            this.region = region;
            return this;
        }

        public Builder region(String region) {
            this.region = Optional.ofNullable(region);
            return this;
        }

        @JsonSetter(value="timezone", nulls=Nulls.SKIP)
        public Builder timezone(Optional<String> timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = Optional.ofNullable(timezone);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="identity_verification", nulls=Nulls.SKIP)
        public Builder identityVerification(Optional<Boolean> identityVerification) {
            this.identityVerification = identityVerification;
            return this;
        }

        public Builder identityVerification(Boolean identityVerification) {
            this.identityVerification = Optional.ofNullable(identityVerification);
            return this;
        }

        public App build() {
            return new App(this.type, this.idCode, this.name, this.region, this.timezone, this.createdAt, this.identityVerification, this.additionalProperties);
        }
    }
}

