/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class IpAllowlist {
    private final Optional<String> type;
    private final Optional<Boolean> enabled;
    private final Optional<List<String>> ipAllowlist;
    private final Map<String, Object> additionalProperties;

    private IpAllowlist(Optional<String> type, Optional<Boolean> enabled, Optional<List<String>> ipAllowlist, Map<String, Object> additionalProperties) {
        this.type = type;
        this.enabled = enabled;
        this.ipAllowlist = ipAllowlist;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="enabled")
    public Optional<Boolean> getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="ip_allowlist")
    public Optional<List<String>> getIpAllowlist() {
        return this.ipAllowlist;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof IpAllowlist && this.equalTo((IpAllowlist)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(IpAllowlist other) {
        return this.type.equals(other.type) && this.enabled.equals(other.enabled) && this.ipAllowlist.equals(other.ipAllowlist);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.enabled, this.ipAllowlist);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<List<String>> ipAllowlist = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(IpAllowlist other) {
            this.type(other.getType());
            this.enabled(other.getEnabled());
            this.ipAllowlist(other.getIpAllowlist());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="enabled", nulls=Nulls.SKIP)
        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = Optional.ofNullable(enabled);
            return this;
        }

        @JsonSetter(value="ip_allowlist", nulls=Nulls.SKIP)
        public Builder ipAllowlist(Optional<List<String>> ipAllowlist) {
            this.ipAllowlist = ipAllowlist;
            return this;
        }

        public Builder ipAllowlist(List<String> ipAllowlist) {
            this.ipAllowlist = Optional.ofNullable(ipAllowlist);
            return this;
        }

        public IpAllowlist build() {
            return new IpAllowlist(this.type, this.enabled, this.ipAllowlist, this.additionalProperties);
        }
    }
}

