/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.internalarticles.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = InternalArticleListItem.Builder.class)
public final class InternalArticleListItem {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> title;

    private final Optional<String> body;

    private final Optional<Integer> ownerId;

    private final Optional<Integer> authorId;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<String> locale;

    private final Map<String, Object> additionalProperties;

    private InternalArticleListItem(
            Optional<String> type,
            Optional<String> id,
            Optional<String> title,
            Optional<String> body,
            Optional<Integer> ownerId,
            Optional<Integer> authorId,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<String> locale,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.title = title;
        this.body = body;
        this.ownerId = ownerId;
        this.authorId = authorId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.locale = locale;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object - <code>internal_article</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The unique identifier for the article which is given by Intercom.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The title of the article.
     */
    @JsonProperty("title")
    public Optional<String> getTitle() {
        return title;
    }

    /**
     * @return The body of the article in HTML.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The id of the owner of the article.
     */
    @JsonProperty("owner_id")
    public Optional<Integer> getOwnerId() {
        return ownerId;
    }

    /**
     * @return The id of the author of the article.
     */
    @JsonProperty("author_id")
    public Optional<Integer> getAuthorId() {
        return authorId;
    }

    /**
     * @return The time when the article was created.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time when the article was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The default locale of the article.
     */
    @JsonProperty("locale")
    public Optional<String> getLocale() {
        return locale;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof InternalArticleListItem && equalTo((InternalArticleListItem) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InternalArticleListItem other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && title.equals(other.title)
                && body.equals(other.body)
                && ownerId.equals(other.ownerId)
                && authorId.equals(other.authorId)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && locale.equals(other.locale);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.title,
                this.body,
                this.ownerId,
                this.authorId,
                this.createdAt,
                this.updatedAt,
                this.locale);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> title = Optional.empty();

        private Optional<String> body = Optional.empty();

        private Optional<Integer> ownerId = Optional.empty();

        private Optional<Integer> authorId = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<String> locale = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(InternalArticleListItem other) {
            type(other.getType());
            id(other.getId());
            title(other.getTitle());
            body(other.getBody());
            ownerId(other.getOwnerId());
            authorId(other.getAuthorId());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            locale(other.getLocale());
            return this;
        }

        /**
         * <p>The type of object - <code>internal_article</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The unique identifier for the article which is given by Intercom.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The title of the article.</p>
         */
        @JsonSetter(value = "title", nulls = Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        /**
         * <p>The body of the article in HTML.</p>
         */
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The id of the owner of the article.</p>
         */
        @JsonSetter(value = "owner_id", nulls = Nulls.SKIP)
        public Builder ownerId(Optional<Integer> ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public Builder ownerId(Integer ownerId) {
            this.ownerId = Optional.ofNullable(ownerId);
            return this;
        }

        /**
         * <p>The id of the author of the article.</p>
         */
        @JsonSetter(value = "author_id", nulls = Nulls.SKIP)
        public Builder authorId(Optional<Integer> authorId) {
            this.authorId = authorId;
            return this;
        }

        public Builder authorId(Integer authorId) {
            this.authorId = Optional.ofNullable(authorId);
            return this;
        }

        /**
         * <p>The time when the article was created.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time when the article was last updated.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The default locale of the article.</p>
         */
        @JsonSetter(value = "locale", nulls = Nulls.SKIP)
        public Builder locale(Optional<String> locale) {
            this.locale = locale;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = Optional.ofNullable(locale);
            return this;
        }

        public InternalArticleListItem build() {
            return new InternalArticleListItem(
                    type, id, title, body, ownerId, authorId, createdAt, updatedAt, locale, additionalProperties);
        }
    }
}
