/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.tickettypes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.tickets.types.TicketType;
import com.intercom.api.resources.unstable.tickettypes.AsyncRawTicketTypesClient;
import com.intercom.api.resources.unstable.tickettypes.requests.GetTicketTypeRequest;
import com.intercom.api.resources.unstable.types.TicketTypeList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncTicketTypesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTicketTypesClient rawClient;

    public AsyncTicketTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTicketTypesClient(clientOptions);
    }

    public AsyncRawTicketTypesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<TicketTypeList> listTicketTypes() {
        return this.rawClient.listTicketTypes().thenApply(response -> (TicketTypeList)response.body());
    }

    public CompletableFuture<TicketTypeList> listTicketTypes(RequestOptions requestOptions) {
        return this.rawClient.listTicketTypes(requestOptions).thenApply(response -> (TicketTypeList)response.body());
    }

    public CompletableFuture<Optional<TicketType>> createTicketType(Object request) {
        return this.rawClient.createTicketType(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<TicketType>> createTicketType(Object request, RequestOptions requestOptions) {
        return this.rawClient.createTicketType(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<TicketType>> getTicketType(GetTicketTypeRequest request) {
        return this.rawClient.getTicketType(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<TicketType>> getTicketType(GetTicketTypeRequest request, RequestOptions requestOptions) {
        return this.rawClient.getTicketType(request, requestOptions).thenApply(response -> (Optional)response.body());
    }
}

