/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Snoozed {
    private final Optional<String> until;
    private final Optional<OffsetDateTime> customUntilTime;
    private final Map<String, Object> additionalProperties;

    private Snoozed(Optional<String> until, Optional<OffsetDateTime> customUntilTime, Map<String, Object> additionalProperties) {
        this.until = until;
        this.customUntilTime = customUntilTime;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="until")
    public Optional<String> getUntil() {
        return this.until;
    }

    @JsonProperty(value="custom_until_time")
    public Optional<OffsetDateTime> getCustomUntilTime() {
        return this.customUntilTime;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Snoozed && this.equalTo((Snoozed)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Snoozed other) {
        return this.until.equals(other.until) && this.customUntilTime.equals(other.customUntilTime);
    }

    public int hashCode() {
        return Objects.hash(this.until, this.customUntilTime);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> until = Optional.empty();
        private Optional<OffsetDateTime> customUntilTime = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Snoozed other) {
            this.until(other.getUntil());
            this.customUntilTime(other.getCustomUntilTime());
            return this;
        }

        @JsonSetter(value="until", nulls=Nulls.SKIP)
        public Builder until(Optional<String> until) {
            this.until = until;
            return this;
        }

        public Builder until(String until) {
            this.until = Optional.ofNullable(until);
            return this;
        }

        @JsonSetter(value="custom_until_time", nulls=Nulls.SKIP)
        public Builder customUntilTime(Optional<OffsetDateTime> customUntilTime) {
            this.customUntilTime = customUntilTime;
            return this;
        }

        public Builder customUntilTime(OffsetDateTime customUntilTime) {
            this.customUntilTime = Optional.ofNullable(customUntilTime);
            return this;
        }

        public Snoozed build() {
            return new Snoozed(this.until, this.customUntilTime, this.additionalProperties);
        }
    }
}

