/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intercom.api.resources.news.types.NewsItem;
import com.intercom.api.resources.news.types.Newsfeed;
import java.util.Objects;
import java.util.Optional;

public final class PaginatedResponseDataItem {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private PaginatedResponseDataItem(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static PaginatedResponseDataItem newsItem(NewsItem value) {
        return new PaginatedResponseDataItem(new NewsItemValue(value));
    }

    public static PaginatedResponseDataItem newsfeed(Newsfeed value) {
        return new PaginatedResponseDataItem(new NewsfeedValue(value));
    }

    public boolean isNewsItem() {
        return this.value instanceof NewsItemValue;
    }

    public boolean isNewsfeed() {
        return this.value instanceof NewsfeedValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<NewsItem> getNewsItem() {
        if (this.isNewsItem()) {
            return Optional.of(((NewsItemValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Newsfeed> getNewsfeed() {
        if (this.isNewsfeed()) {
            return Optional.of(((NewsfeedValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "PaginatedResponseDataItem{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="newsfeed")
    @JsonIgnoreProperties(value={"type"})
    private static final class NewsfeedValue
    implements Value {
        @JsonUnwrapped
        private Newsfeed value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private NewsfeedValue() {
        }

        private NewsfeedValue(Newsfeed value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitNewsfeed(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof NewsfeedValue && this.equalTo((NewsfeedValue)other);
        }

        private boolean equalTo(NewsfeedValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "PaginatedResponseDataItem{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="news-item")
    @JsonIgnoreProperties(value={"type"})
    private static final class NewsItemValue
    implements Value {
        @JsonUnwrapped
        private NewsItem value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private NewsItemValue() {
        }

        private NewsItemValue(NewsItem value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitNewsItem(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof NewsItemValue && this.equalTo((NewsItemValue)other);
        }

        private boolean equalTo(NewsItemValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "PaginatedResponseDataItem{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=NewsItemValue.class), @JsonSubTypes.Type(value=NewsfeedValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitNewsItem(NewsItem var1);

        public T visitNewsfeed(Newsfeed var1);

        public T _visitUnknown(Object var1);
    }
}

