/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.dataexport.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateDataExportsRequest.Builder.class)
public final class CreateDataExportsRequest {
    private final int createdAtAfter;

    private final int createdAtBefore;

    private final Map<String, Object> additionalProperties;

    private CreateDataExportsRequest(
            int createdAtAfter, int createdAtBefore, Map<String, Object> additionalProperties) {
        this.createdAtAfter = createdAtAfter;
        this.createdAtBefore = createdAtBefore;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The start date that you request data for. It must be formatted as a unix timestamp.
     */
    @JsonProperty("created_at_after")
    public int getCreatedAtAfter() {
        return createdAtAfter;
    }

    /**
     * @return The end date that you request data for. It must be formatted as a unix timestamp.
     */
    @JsonProperty("created_at_before")
    public int getCreatedAtBefore() {
        return createdAtBefore;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateDataExportsRequest && equalTo((CreateDataExportsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateDataExportsRequest other) {
        return createdAtAfter == other.createdAtAfter && createdAtBefore == other.createdAtBefore;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.createdAtAfter, this.createdAtBefore);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtAfterStage builder() {
        return new Builder();
    }

    public interface CreatedAtAfterStage {
        /**
         * <p>The start date that you request data for. It must be formatted as a unix timestamp.</p>
         */
        CreatedAtBeforeStage createdAtAfter(int createdAtAfter);

        Builder from(CreateDataExportsRequest other);
    }

    public interface CreatedAtBeforeStage {
        /**
         * <p>The end date that you request data for. It must be formatted as a unix timestamp.</p>
         */
        _FinalStage createdAtBefore(int createdAtBefore);
    }

    public interface _FinalStage {
        CreateDataExportsRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CreatedAtAfterStage, CreatedAtBeforeStage, _FinalStage {
        private int createdAtAfter;

        private int createdAtBefore;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateDataExportsRequest other) {
            createdAtAfter(other.getCreatedAtAfter());
            createdAtBefore(other.getCreatedAtBefore());
            return this;
        }

        /**
         * <p>The start date that you request data for. It must be formatted as a unix timestamp.</p>
         * <p>The start date that you request data for. It must be formatted as a unix timestamp.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at_after")
        public CreatedAtBeforeStage createdAtAfter(int createdAtAfter) {
            this.createdAtAfter = createdAtAfter;
            return this;
        }

        /**
         * <p>The end date that you request data for. It must be formatted as a unix timestamp.</p>
         * <p>The end date that you request data for. It must be formatted as a unix timestamp.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at_before")
        public _FinalStage createdAtBefore(int createdAtBefore) {
            this.createdAtBefore = createdAtBefore;
            return this;
        }

        @java.lang.Override
        public CreateDataExportsRequest build() {
            return new CreateDataExportsRequest(createdAtAfter, createdAtBefore, additionalProperties);
        }
    }
}
