/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.macros.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListMacrosRequest.Builder.class)
public final class ListMacrosRequest {
    private final Optional<Integer> perPage;

    private final Optional<String> startingAfter;

    private final Optional<Long> updatedSince;

    private final Map<String, Object> additionalProperties;

    private ListMacrosRequest(
            Optional<Integer> perPage,
            Optional<String> startingAfter,
            Optional<Long> updatedSince,
            Map<String, Object> additionalProperties) {
        this.perPage = perPage;
        this.startingAfter = startingAfter;
        this.updatedSince = updatedSince;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The number of results per page
     */
    @JsonProperty("per_page")
    public Optional<Integer> getPerPage() {
        return perPage;
    }

    /**
     * @return Base64-encoded cursor containing [updated_at, id] for pagination
     */
    @JsonProperty("starting_after")
    public Optional<String> getStartingAfter() {
        return startingAfter;
    }

    /**
     * @return Unix timestamp to filter macros updated after this time
     */
    @JsonProperty("updated_since")
    public Optional<Long> getUpdatedSince() {
        return updatedSince;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListMacrosRequest && equalTo((ListMacrosRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListMacrosRequest other) {
        return perPage.equals(other.perPage)
                && startingAfter.equals(other.startingAfter)
                && updatedSince.equals(other.updatedSince);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.perPage, this.startingAfter, this.updatedSince);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Integer> perPage = Optional.empty();

        private Optional<String> startingAfter = Optional.empty();

        private Optional<Long> updatedSince = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListMacrosRequest other) {
            perPage(other.getPerPage());
            startingAfter(other.getStartingAfter());
            updatedSince(other.getUpdatedSince());
            return this;
        }

        /**
         * <p>The number of results per page</p>
         */
        @JsonSetter(value = "per_page", nulls = Nulls.SKIP)
        public Builder perPage(Optional<Integer> perPage) {
            this.perPage = perPage;
            return this;
        }

        public Builder perPage(Integer perPage) {
            this.perPage = Optional.ofNullable(perPage);
            return this;
        }

        /**
         * <p>Base64-encoded cursor containing [updated_at, id] for pagination</p>
         */
        @JsonSetter(value = "starting_after", nulls = Nulls.SKIP)
        public Builder startingAfter(Optional<String> startingAfter) {
            this.startingAfter = startingAfter;
            return this;
        }

        public Builder startingAfter(String startingAfter) {
            this.startingAfter = Optional.ofNullable(startingAfter);
            return this;
        }

        /**
         * <p>Unix timestamp to filter macros updated after this time</p>
         */
        @JsonSetter(value = "updated_since", nulls = Nulls.SKIP)
        public Builder updatedSince(Optional<Long> updatedSince) {
            this.updatedSince = updatedSince;
            return this;
        }

        public Builder updatedSince(Long updatedSince) {
            this.updatedSince = Optional.ofNullable(updatedSince);
            return this;
        }

        public ListMacrosRequest build() {
            return new ListMacrosRequest(perPage, startingAfter, updatedSince, additionalProperties);
        }
    }
}
