/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CloseConversationRequest.Builder.class)
public final class CloseConversationRequest {
    private final String adminId;

    private final Optional<String> body;

    private final Map<String, Object> additionalProperties;

    private CloseConversationRequest(String adminId, Optional<String> body, Map<String, Object> additionalProperties) {
        this.adminId = adminId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("type")
    public String getType() {
        return "admin";
    }

    /**
     * @return The id of the admin who is performing the action.
     */
    @JsonProperty("admin_id")
    public String getAdminId() {
        return adminId;
    }

    /**
     * @return Optionally you can leave a message in the conversation to provide additional context to the user and other teammates.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CloseConversationRequest && equalTo((CloseConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CloseConversationRequest other) {
        return adminId.equals(other.adminId) && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.adminId, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AdminIdStage builder() {
        return new Builder();
    }

    public interface AdminIdStage {
        /**
         * <p>The id of the admin who is performing the action.</p>
         */
        _FinalStage adminId(@NotNull String adminId);

        Builder from(CloseConversationRequest other);
    }

    public interface _FinalStage {
        CloseConversationRequest build();

        /**
         * <p>Optionally you can leave a message in the conversation to provide additional context to the user and other teammates.</p>
         */
        _FinalStage body(Optional<String> body);

        _FinalStage body(String body);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements AdminIdStage, _FinalStage {
        private String adminId;

        private Optional<String> body = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CloseConversationRequest other) {
            adminId(other.getAdminId());
            body(other.getBody());
            return this;
        }

        /**
         * <p>The id of the admin who is performing the action.</p>
         * <p>The id of the admin who is performing the action.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("admin_id")
        public _FinalStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        /**
         * <p>Optionally you can leave a message in the conversation to provide additional context to the user and other teammates.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>Optionally you can leave a message in the conversation to provide additional context to the user and other teammates.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @java.lang.Override
        public CloseConversationRequest build() {
            return new CloseConversationRequest(adminId, body, additionalProperties);
        }
    }
}
