/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationRating.Builder.class)
public final class ConversationRating {
    private final int rating;

    private final Optional<String> remark;

    private final int createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<ContactReference> contact;

    private final Optional<Reference> teammate;

    private final Map<String, Object> additionalProperties;

    private ConversationRating(
            int rating,
            Optional<String> remark,
            int createdAt,
            Optional<Integer> updatedAt,
            Optional<ContactReference> contact,
            Optional<Reference> teammate,
            Map<String, Object> additionalProperties) {
        this.rating = rating;
        this.remark = remark;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.contact = contact;
        this.teammate = teammate;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The rating, between 1 and 5, for the conversation.
     */
    @JsonProperty("rating")
    public int getRating() {
        return rating;
    }

    /**
     * @return An optional field to add a remark to correspond to the number rating
     */
    @JsonProperty("remark")
    public Optional<String> getRemark() {
        return remark;
    }

    /**
     * @return The time the rating was requested in the conversation being rated.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time the rating was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("contact")
    public Optional<ContactReference> getContact() {
        return contact;
    }

    @JsonProperty("teammate")
    public Optional<Reference> getTeammate() {
        return teammate;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationRating && equalTo((ConversationRating) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationRating other) {
        return rating == other.rating
                && remark.equals(other.remark)
                && createdAt == other.createdAt
                && updatedAt.equals(other.updatedAt)
                && contact.equals(other.contact)
                && teammate.equals(other.teammate);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.rating, this.remark, this.createdAt, this.updatedAt, this.contact, this.teammate);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RatingStage builder() {
        return new Builder();
    }

    public interface RatingStage {
        /**
         * <p>The rating, between 1 and 5, for the conversation.</p>
         */
        CreatedAtStage rating(int rating);

        Builder from(ConversationRating other);
    }

    public interface CreatedAtStage {
        /**
         * <p>The time the rating was requested in the conversation being rated.</p>
         */
        _FinalStage createdAt(int createdAt);
    }

    public interface _FinalStage {
        ConversationRating build();

        /**
         * <p>An optional field to add a remark to correspond to the number rating</p>
         */
        _FinalStage remark(Optional<String> remark);

        _FinalStage remark(String remark);

        /**
         * <p>The time the rating was last updated.</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);

        _FinalStage contact(Optional<ContactReference> contact);

        _FinalStage contact(ContactReference contact);

        _FinalStage teammate(Optional<Reference> teammate);

        _FinalStage teammate(Reference teammate);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements RatingStage, CreatedAtStage, _FinalStage {
        private int rating;

        private int createdAt;

        private Optional<Reference> teammate = Optional.empty();

        private Optional<ContactReference> contact = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<String> remark = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConversationRating other) {
            rating(other.getRating());
            remark(other.getRemark());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            contact(other.getContact());
            teammate(other.getTeammate());
            return this;
        }

        /**
         * <p>The rating, between 1 and 5, for the conversation.</p>
         * <p>The rating, between 1 and 5, for the conversation.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("rating")
        public CreatedAtStage rating(int rating) {
            this.rating = rating;
            return this;
        }

        /**
         * <p>The time the rating was requested in the conversation being rated.</p>
         * <p>The time the rating was requested in the conversation being rated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage teammate(Reference teammate) {
            this.teammate = Optional.ofNullable(teammate);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "teammate", nulls = Nulls.SKIP)
        public _FinalStage teammate(Optional<Reference> teammate) {
            this.teammate = teammate;
            return this;
        }

        @java.lang.Override
        public _FinalStage contact(ContactReference contact) {
            this.contact = Optional.ofNullable(contact);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "contact", nulls = Nulls.SKIP)
        public _FinalStage contact(Optional<ContactReference> contact) {
            this.contact = contact;
            return this;
        }

        /**
         * <p>The time the rating was last updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The time the rating was last updated.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>An optional field to add a remark to correspond to the number rating</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage remark(String remark) {
            this.remark = Optional.ofNullable(remark);
            return this;
        }

        /**
         * <p>An optional field to add a remark to correspond to the number rating</p>
         */
        @java.lang.Override
        @JsonSetter(value = "remark", nulls = Nulls.SKIP)
        public _FinalStage remark(Optional<String> remark) {
            this.remark = remark;
            return this;
        }

        @java.lang.Override
        public ConversationRating build() {
            return new ConversationRating(
                    rating, remark, createdAt, updatedAt, contact, teammate, additionalProperties);
        }
    }
}
