/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.notes.types.Note;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = NoteList.Builder.class)
public final class NoteList {
    private final Optional<String> type;

    private final Optional<List<Note>> data;

    private final Optional<Integer> totalCount;

    private final Map<String, Object> additionalProperties;

    private NoteList(
            Optional<String> type,
            Optional<List<Note>> data,
            Optional<Integer> totalCount,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.data = data;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>list</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return An array of notes.
     */
    @JsonProperty("data")
    public Optional<List<Note>> getData() {
        return data;
    }

    /**
     * @return A count of the total number of notes.
     */
    @JsonProperty("total_count")
    public Optional<Integer> getTotalCount() {
        return totalCount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof NoteList && equalTo((NoteList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NoteList other) {
        return type.equals(other.type) && data.equals(other.data) && totalCount.equals(other.totalCount);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.data, this.totalCount);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Note>> data = Optional.empty();

        private Optional<Integer> totalCount = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(NoteList other) {
            type(other.getType());
            data(other.getData());
            totalCount(other.getTotalCount());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>list</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>An array of notes.</p>
         */
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(Optional<List<Note>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<Note> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        /**
         * <p>A count of the total number of notes.</p>
         */
        @JsonSetter(value = "total_count", nulls = Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        public NoteList build() {
            return new NoteList(type, data, totalCount, additionalProperties);
        }
    }
}
