/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PartAttachment.Builder.class)
public final class PartAttachment {
    private final String type;

    private final String name;

    private final String url;

    private final Optional<String> contentType;

    private final Optional<Integer> filesize;

    private final Optional<Integer> width;

    private final Optional<Integer> height;

    private final Map<String, Object> additionalProperties;

    private PartAttachment(
            String type,
            String name,
            String url,
            Optional<String> contentType,
            Optional<Integer> filesize,
            Optional<Integer> width,
            Optional<Integer> height,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.name = name;
        this.url = url;
        this.contentType = contentType;
        this.filesize = filesize;
        this.width = width;
        this.height = height;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of attachment
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return The name of the attachment
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The URL of the attachment
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    /**
     * @return The content type of the attachment
     */
    @JsonProperty("content_type")
    public Optional<String> getContentType() {
        return contentType;
    }

    /**
     * @return The size of the attachment
     */
    @JsonProperty("filesize")
    public Optional<Integer> getFilesize() {
        return filesize;
    }

    /**
     * @return The width of the attachment
     */
    @JsonProperty("width")
    public Optional<Integer> getWidth() {
        return width;
    }

    /**
     * @return The height of the attachment
     */
    @JsonProperty("height")
    public Optional<Integer> getHeight() {
        return height;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PartAttachment && equalTo((PartAttachment) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PartAttachment other) {
        return type.equals(other.type)
                && name.equals(other.name)
                && url.equals(other.url)
                && contentType.equals(other.contentType)
                && filesize.equals(other.filesize)
                && width.equals(other.width)
                && height.equals(other.height);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.name, this.url, this.contentType, this.filesize, this.width, this.height);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * <p>The type of attachment</p>
         */
        NameStage type(@NotNull String type);

        Builder from(PartAttachment other);
    }

    public interface NameStage {
        /**
         * <p>The name of the attachment</p>
         */
        UrlStage name(@NotNull String name);
    }

    public interface UrlStage {
        /**
         * <p>The URL of the attachment</p>
         */
        _FinalStage url(@NotNull String url);
    }

    public interface _FinalStage {
        PartAttachment build();

        /**
         * <p>The content type of the attachment</p>
         */
        _FinalStage contentType(Optional<String> contentType);

        _FinalStage contentType(String contentType);

        /**
         * <p>The size of the attachment</p>
         */
        _FinalStage filesize(Optional<Integer> filesize);

        _FinalStage filesize(Integer filesize);

        /**
         * <p>The width of the attachment</p>
         */
        _FinalStage width(Optional<Integer> width);

        _FinalStage width(Integer width);

        /**
         * <p>The height of the attachment</p>
         */
        _FinalStage height(Optional<Integer> height);

        _FinalStage height(Integer height);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, NameStage, UrlStage, _FinalStage {
        private String type;

        private String name;

        private String url;

        private Optional<Integer> height = Optional.empty();

        private Optional<Integer> width = Optional.empty();

        private Optional<Integer> filesize = Optional.empty();

        private Optional<String> contentType = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PartAttachment other) {
            type(other.getType());
            name(other.getName());
            url(other.getUrl());
            contentType(other.getContentType());
            filesize(other.getFilesize());
            width(other.getWidth());
            height(other.getHeight());
            return this;
        }

        /**
         * <p>The type of attachment</p>
         * <p>The type of attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public NameStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>The name of the attachment</p>
         * <p>The name of the attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public UrlStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * <p>The URL of the attachment</p>
         * <p>The URL of the attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        /**
         * <p>The height of the attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage height(Integer height) {
            this.height = Optional.ofNullable(height);
            return this;
        }

        /**
         * <p>The height of the attachment</p>
         */
        @java.lang.Override
        @JsonSetter(value = "height", nulls = Nulls.SKIP)
        public _FinalStage height(Optional<Integer> height) {
            this.height = height;
            return this;
        }

        /**
         * <p>The width of the attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage width(Integer width) {
            this.width = Optional.ofNullable(width);
            return this;
        }

        /**
         * <p>The width of the attachment</p>
         */
        @java.lang.Override
        @JsonSetter(value = "width", nulls = Nulls.SKIP)
        public _FinalStage width(Optional<Integer> width) {
            this.width = width;
            return this;
        }

        /**
         * <p>The size of the attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage filesize(Integer filesize) {
            this.filesize = Optional.ofNullable(filesize);
            return this;
        }

        /**
         * <p>The size of the attachment</p>
         */
        @java.lang.Override
        @JsonSetter(value = "filesize", nulls = Nulls.SKIP)
        public _FinalStage filesize(Optional<Integer> filesize) {
            this.filesize = filesize;
            return this;
        }

        /**
         * <p>The content type of the attachment</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage contentType(String contentType) {
            this.contentType = Optional.ofNullable(contentType);
            return this;
        }

        /**
         * <p>The content type of the attachment</p>
         */
        @java.lang.Override
        @JsonSetter(value = "content_type", nulls = Nulls.SKIP)
        public _FinalStage contentType(Optional<String> contentType) {
            this.contentType = contentType;
            return this;
        }

        @java.lang.Override
        public PartAttachment build() {
            return new PartAttachment(type, name, url, contentType, filesize, width, height, additionalProperties);
        }
    }
}
