/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AiCallResponse {
    private final Optional<Integer> id;
    private final Optional<Integer> appId;
    private final Optional<String> userPhoneNumber;
    private final Optional<String> status;
    private final Optional<String> intercomCallId;
    private final Optional<String> externalCallId;
    private final Optional<String> intercomConversationId;
    private final Optional<List<Map<String, Object>>> callTranscript;
    private final Optional<String> callSummary;
    private final Optional<List<Map<String, Object>>> intent;
    private final Map<String, Object> additionalProperties;

    private AiCallResponse(Optional<Integer> id, Optional<Integer> appId, Optional<String> userPhoneNumber, Optional<String> status, Optional<String> intercomCallId, Optional<String> externalCallId, Optional<String> intercomConversationId, Optional<List<Map<String, Object>>> callTranscript, Optional<String> callSummary, Optional<List<Map<String, Object>>> intent, Map<String, Object> additionalProperties) {
        this.id = id;
        this.appId = appId;
        this.userPhoneNumber = userPhoneNumber;
        this.status = status;
        this.intercomCallId = intercomCallId;
        this.externalCallId = externalCallId;
        this.intercomConversationId = intercomConversationId;
        this.callTranscript = callTranscript;
        this.callSummary = callSummary;
        this.intent = intent;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<Integer> getId() {
        return this.id;
    }

    @JsonProperty(value="app_id")
    public Optional<Integer> getAppId() {
        return this.appId;
    }

    @JsonProperty(value="user_phone_number")
    public Optional<String> getUserPhoneNumber() {
        return this.userPhoneNumber;
    }

    @JsonProperty(value="status")
    public Optional<String> getStatus() {
        return this.status;
    }

    @JsonProperty(value="intercom_call_id")
    public Optional<String> getIntercomCallId() {
        return this.intercomCallId;
    }

    @JsonProperty(value="external_call_id")
    public Optional<String> getExternalCallId() {
        return this.externalCallId;
    }

    @JsonProperty(value="intercom_conversation_id")
    public Optional<String> getIntercomConversationId() {
        return this.intercomConversationId;
    }

    @JsonProperty(value="call_transcript")
    public Optional<List<Map<String, Object>>> getCallTranscript() {
        return this.callTranscript;
    }

    @JsonProperty(value="call_summary")
    public Optional<String> getCallSummary() {
        return this.callSummary;
    }

    @JsonProperty(value="intent")
    public Optional<List<Map<String, Object>>> getIntent() {
        return this.intent;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AiCallResponse && this.equalTo((AiCallResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AiCallResponse other) {
        return this.id.equals(other.id) && this.appId.equals(other.appId) && this.userPhoneNumber.equals(other.userPhoneNumber) && this.status.equals(other.status) && this.intercomCallId.equals(other.intercomCallId) && this.externalCallId.equals(other.externalCallId) && this.intercomConversationId.equals(other.intercomConversationId) && this.callTranscript.equals(other.callTranscript) && this.callSummary.equals(other.callSummary) && this.intent.equals(other.intent);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.appId, this.userPhoneNumber, this.status, this.intercomCallId, this.externalCallId, this.intercomConversationId, this.callTranscript, this.callSummary, this.intent);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> id = Optional.empty();
        private Optional<Integer> appId = Optional.empty();
        private Optional<String> userPhoneNumber = Optional.empty();
        private Optional<String> status = Optional.empty();
        private Optional<String> intercomCallId = Optional.empty();
        private Optional<String> externalCallId = Optional.empty();
        private Optional<String> intercomConversationId = Optional.empty();
        private Optional<List<Map<String, Object>>> callTranscript = Optional.empty();
        private Optional<String> callSummary = Optional.empty();
        private Optional<List<Map<String, Object>>> intent = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(AiCallResponse other) {
            this.id(other.getId());
            this.appId(other.getAppId());
            this.userPhoneNumber(other.getUserPhoneNumber());
            this.status(other.getStatus());
            this.intercomCallId(other.getIntercomCallId());
            this.externalCallId(other.getExternalCallId());
            this.intercomConversationId(other.getIntercomConversationId());
            this.callTranscript(other.getCallTranscript());
            this.callSummary(other.getCallSummary());
            this.intent(other.getIntent());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<Integer> id) {
            this.id = id;
            return this;
        }

        public Builder id(Integer id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="app_id", nulls=Nulls.SKIP)
        public Builder appId(Optional<Integer> appId) {
            this.appId = appId;
            return this;
        }

        public Builder appId(Integer appId) {
            this.appId = Optional.ofNullable(appId);
            return this;
        }

        @JsonSetter(value="user_phone_number", nulls=Nulls.SKIP)
        public Builder userPhoneNumber(Optional<String> userPhoneNumber) {
            this.userPhoneNumber = userPhoneNumber;
            return this;
        }

        public Builder userPhoneNumber(String userPhoneNumber) {
            this.userPhoneNumber = Optional.ofNullable(userPhoneNumber);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<String> status) {
            this.status = status;
            return this;
        }

        public Builder status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="intercom_call_id", nulls=Nulls.SKIP)
        public Builder intercomCallId(Optional<String> intercomCallId) {
            this.intercomCallId = intercomCallId;
            return this;
        }

        public Builder intercomCallId(String intercomCallId) {
            this.intercomCallId = Optional.ofNullable(intercomCallId);
            return this;
        }

        @JsonSetter(value="external_call_id", nulls=Nulls.SKIP)
        public Builder externalCallId(Optional<String> externalCallId) {
            this.externalCallId = externalCallId;
            return this;
        }

        public Builder externalCallId(String externalCallId) {
            this.externalCallId = Optional.ofNullable(externalCallId);
            return this;
        }

        @JsonSetter(value="intercom_conversation_id", nulls=Nulls.SKIP)
        public Builder intercomConversationId(Optional<String> intercomConversationId) {
            this.intercomConversationId = intercomConversationId;
            return this;
        }

        public Builder intercomConversationId(String intercomConversationId) {
            this.intercomConversationId = Optional.ofNullable(intercomConversationId);
            return this;
        }

        @JsonSetter(value="call_transcript", nulls=Nulls.SKIP)
        public Builder callTranscript(Optional<List<Map<String, Object>>> callTranscript) {
            this.callTranscript = callTranscript;
            return this;
        }

        public Builder callTranscript(List<Map<String, Object>> callTranscript) {
            this.callTranscript = Optional.ofNullable(callTranscript);
            return this;
        }

        @JsonSetter(value="call_summary", nulls=Nulls.SKIP)
        public Builder callSummary(Optional<String> callSummary) {
            this.callSummary = callSummary;
            return this;
        }

        public Builder callSummary(String callSummary) {
            this.callSummary = Optional.ofNullable(callSummary);
            return this;
        }

        @JsonSetter(value="intent", nulls=Nulls.SKIP)
        public Builder intent(Optional<List<Map<String, Object>>> intent) {
            this.intent = intent;
            return this;
        }

        public Builder intent(List<Map<String, Object>> intent) {
            this.intent = Optional.ofNullable(intent);
            return this;
        }

        public AiCallResponse build() {
            return new AiCallResponse(this.id, this.appId, this.userPhoneNumber, this.status, this.intercomCallId, this.externalCallId, this.intercomConversationId, this.callTranscript, this.callSummary, this.intent, this.additionalProperties);
        }
    }
}

