/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.tags.types.TagBasic;
import com.intercom.api.types.ConversationPartAuthor;
import com.intercom.api.types.ConversationPartMetadata;
import com.intercom.api.types.EmailMessageMetadata;
import com.intercom.api.types.EventDetails;
import com.intercom.api.types.PartAttachment;
import com.intercom.api.types.Reference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationPart {
    private final String type;
    private final String id;
    private final String partType;
    private final Optional<String> body;
    private final int createdAt;
    private final int updatedAt;
    private final Optional<Integer> notifiedAt;
    private final Optional<Reference> assignedTo;
    private final ConversationPartAuthor author;
    private final Optional<List<PartAttachment>> attachments;
    private final Optional<String> externalId;
    private final boolean redacted;
    private final Optional<EmailMessageMetadata> emailMessageMetadata;
    private final Optional<ConversationPartMetadata> metadata;
    private final Optional<State> state;
    private final Optional<List<TagBasic>> tags;
    private final Optional<EventDetails> eventDetails;
    private final Optional<String> appPackageCode;
    private final Map<String, Object> additionalProperties;

    private ConversationPart(String type, String id, String partType, Optional<String> body, int createdAt, int updatedAt, Optional<Integer> notifiedAt, Optional<Reference> assignedTo, ConversationPartAuthor author, Optional<List<PartAttachment>> attachments, Optional<String> externalId, boolean redacted, Optional<EmailMessageMetadata> emailMessageMetadata, Optional<ConversationPartMetadata> metadata, Optional<State> state, Optional<List<TagBasic>> tags, Optional<EventDetails> eventDetails, Optional<String> appPackageCode, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.partType = partType;
        this.body = body;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.notifiedAt = notifiedAt;
        this.assignedTo = assignedTo;
        this.author = author;
        this.attachments = attachments;
        this.externalId = externalId;
        this.redacted = redacted;
        this.emailMessageMetadata = emailMessageMetadata;
        this.metadata = metadata;
        this.state = state;
        this.tags = tags;
        this.eventDetails = eventDetails;
        this.appPackageCode = appPackageCode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="part_type")
    public String getPartType() {
        return this.partType;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public int getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="notified_at")
    public Optional<Integer> getNotifiedAt() {
        return this.notifiedAt;
    }

    @JsonProperty(value="assigned_to")
    public Optional<Reference> getAssignedTo() {
        return this.assignedTo;
    }

    @JsonProperty(value="author")
    public ConversationPartAuthor getAuthor() {
        return this.author;
    }

    @JsonProperty(value="attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="redacted")
    public boolean getRedacted() {
        return this.redacted;
    }

    @JsonProperty(value="email_message_metadata")
    public Optional<EmailMessageMetadata> getEmailMessageMetadata() {
        return this.emailMessageMetadata;
    }

    @JsonProperty(value="metadata")
    public Optional<ConversationPartMetadata> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="state")
    public Optional<State> getState() {
        return this.state;
    }

    @JsonProperty(value="tags")
    public Optional<List<TagBasic>> getTags() {
        return this.tags;
    }

    @JsonProperty(value="event_details")
    public Optional<EventDetails> getEventDetails() {
        return this.eventDetails;
    }

    @JsonProperty(value="app_package_code")
    public Optional<String> getAppPackageCode() {
        return this.appPackageCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationPart && this.equalTo((ConversationPart)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationPart other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.partType.equals(other.partType) && this.body.equals(other.body) && this.createdAt == other.createdAt && this.updatedAt == other.updatedAt && this.notifiedAt.equals(other.notifiedAt) && this.assignedTo.equals(other.assignedTo) && this.author.equals(other.author) && this.attachments.equals(other.attachments) && this.externalId.equals(other.externalId) && this.redacted == other.redacted && this.emailMessageMetadata.equals(other.emailMessageMetadata) && this.metadata.equals(other.metadata) && this.state.equals(other.state) && this.tags.equals(other.tags) && this.eventDetails.equals(other.eventDetails) && this.appPackageCode.equals(other.appPackageCode);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.partType, this.body, this.createdAt, this.updatedAt, this.notifiedAt, this.assignedTo, this.author, this.attachments, this.externalId, this.redacted, this.emailMessageMetadata, this.metadata, this.state, this.tags, this.eventDetails, this.appPackageCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public static final class State {
        public static final State SNOOZED = new State(Value.SNOOZED, "snoozed");
        public static final State CLOSED = new State(Value.CLOSED, "closed");
        public static final State OPEN = new State(Value.OPEN, "open");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case SNOOZED: {
                    return visitor.visitSnoozed();
                }
                case CLOSED: {
                    return visitor.visitClosed();
                }
                case OPEN: {
                    return visitor.visitOpen();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "snoozed": {
                    return SNOOZED;
                }
                case "closed": {
                    return CLOSED;
                }
                case "open": {
                    return OPEN;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitOpen();

            public T visitClosed();

            public T visitSnoozed();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            OPEN,
            CLOSED,
            SNOOZED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    IdStage,
    PartTypeStage,
    CreatedAtStage,
    UpdatedAtStage,
    AuthorStage,
    RedactedStage,
    _FinalStage {
        private String type;
        private String id;
        private String partType;
        private int createdAt;
        private int updatedAt;
        private ConversationPartAuthor author;
        private boolean redacted;
        private Optional<String> appPackageCode = Optional.empty();
        private Optional<EventDetails> eventDetails = Optional.empty();
        private Optional<List<TagBasic>> tags = Optional.empty();
        private Optional<State> state = Optional.empty();
        private Optional<ConversationPartMetadata> metadata = Optional.empty();
        private Optional<EmailMessageMetadata> emailMessageMetadata = Optional.empty();
        private Optional<String> externalId = Optional.empty();
        private Optional<List<PartAttachment>> attachments = Optional.empty();
        private Optional<Reference> assignedTo = Optional.empty();
        private Optional<Integer> notifiedAt = Optional.empty();
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConversationPart other) {
            this.type(other.getType());
            this.id(other.getId());
            this.partType(other.getPartType());
            this.body(other.getBody());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.notifiedAt(other.getNotifiedAt());
            this.assignedTo(other.getAssignedTo());
            this.author(other.getAuthor());
            this.attachments(other.getAttachments());
            this.externalId(other.getExternalId());
            this.redacted(other.getRedacted());
            this.emailMessageMetadata(other.getEmailMessageMetadata());
            this.metadata(other.getMetadata());
            this.state(other.getState());
            this.tags(other.getTags());
            this.eventDetails(other.getEventDetails());
            this.appPackageCode(other.getAppPackageCode());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public IdStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public PartTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="part_type")
        public CreatedAtStage partType(@NotNull String partType) {
            this.partType = Objects.requireNonNull(partType, "partType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public AuthorStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        @JsonSetter(value="author")
        public RedactedStage author(@NotNull ConversationPartAuthor author) {
            this.author = Objects.requireNonNull(author, "author must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="redacted")
        public _FinalStage redacted(boolean redacted) {
            this.redacted = redacted;
            return this;
        }

        @Override
        public _FinalStage appPackageCode(String appPackageCode) {
            this.appPackageCode = Optional.ofNullable(appPackageCode);
            return this;
        }

        @Override
        @JsonSetter(value="app_package_code", nulls=Nulls.SKIP)
        public _FinalStage appPackageCode(Optional<String> appPackageCode) {
            this.appPackageCode = appPackageCode;
            return this;
        }

        @Override
        public _FinalStage eventDetails(EventDetails eventDetails) {
            this.eventDetails = Optional.ofNullable(eventDetails);
            return this;
        }

        @Override
        @JsonSetter(value="event_details", nulls=Nulls.SKIP)
        public _FinalStage eventDetails(Optional<EventDetails> eventDetails) {
            this.eventDetails = eventDetails;
            return this;
        }

        @Override
        public _FinalStage tags(List<TagBasic> tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @Override
        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public _FinalStage tags(Optional<List<TagBasic>> tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public _FinalStage state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @Override
        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public _FinalStage state(Optional<State> state) {
            this.state = state;
            return this;
        }

        @Override
        public _FinalStage metadata(ConversationPartMetadata metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<ConversationPartMetadata> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage emailMessageMetadata(EmailMessageMetadata emailMessageMetadata) {
            this.emailMessageMetadata = Optional.ofNullable(emailMessageMetadata);
            return this;
        }

        @Override
        @JsonSetter(value="email_message_metadata", nulls=Nulls.SKIP)
        public _FinalStage emailMessageMetadata(Optional<EmailMessageMetadata> emailMessageMetadata) {
            this.emailMessageMetadata = emailMessageMetadata;
            return this;
        }

        @Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @Override
        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public _FinalStage attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        @Override
        @JsonSetter(value="attachments", nulls=Nulls.SKIP)
        public _FinalStage attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        @Override
        public _FinalStage assignedTo(Reference assignedTo) {
            this.assignedTo = Optional.ofNullable(assignedTo);
            return this;
        }

        @Override
        @JsonSetter(value="assigned_to", nulls=Nulls.SKIP)
        public _FinalStage assignedTo(Optional<Reference> assignedTo) {
            this.assignedTo = assignedTo;
            return this;
        }

        @Override
        public _FinalStage notifiedAt(Integer notifiedAt) {
            this.notifiedAt = Optional.ofNullable(notifiedAt);
            return this;
        }

        @Override
        @JsonSetter(value="notified_at", nulls=Nulls.SKIP)
        public _FinalStage notifiedAt(Optional<Integer> notifiedAt) {
            this.notifiedAt = notifiedAt;
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public ConversationPart build() {
            return new ConversationPart(this.type, this.id, this.partType, this.body, this.createdAt, this.updatedAt, this.notifiedAt, this.assignedTo, this.author, this.attachments, this.externalId, this.redacted, this.emailMessageMetadata, this.metadata, this.state, this.tags, this.eventDetails, this.appPackageCode, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConversationPart build();

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);

        public _FinalStage notifiedAt(Optional<Integer> var1);

        public _FinalStage notifiedAt(Integer var1);

        public _FinalStage assignedTo(Optional<Reference> var1);

        public _FinalStage assignedTo(Reference var1);

        public _FinalStage attachments(Optional<List<PartAttachment>> var1);

        public _FinalStage attachments(List<PartAttachment> var1);

        public _FinalStage externalId(Optional<String> var1);

        public _FinalStage externalId(String var1);

        public _FinalStage emailMessageMetadata(Optional<EmailMessageMetadata> var1);

        public _FinalStage emailMessageMetadata(EmailMessageMetadata var1);

        public _FinalStage metadata(Optional<ConversationPartMetadata> var1);

        public _FinalStage metadata(ConversationPartMetadata var1);

        public _FinalStage state(Optional<State> var1);

        public _FinalStage state(State var1);

        public _FinalStage tags(Optional<List<TagBasic>> var1);

        public _FinalStage tags(List<TagBasic> var1);

        public _FinalStage eventDetails(Optional<EventDetails> var1);

        public _FinalStage eventDetails(EventDetails var1);

        public _FinalStage appPackageCode(Optional<String> var1);

        public _FinalStage appPackageCode(String var1);
    }

    public static interface RedactedStage {
        public _FinalStage redacted(boolean var1);
    }

    public static interface AuthorStage {
        public RedactedStage author(@NotNull ConversationPartAuthor var1);
    }

    public static interface UpdatedAtStage {
        public AuthorStage updatedAt(int var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(int var1);
    }

    public static interface PartTypeStage {
        public CreatedAtStage partType(@NotNull String var1);
    }

    public static interface IdStage {
        public PartTypeStage id(@NotNull String var1);
    }

    public static interface TypeStage {
        public IdStage type(@NotNull String var1);

        public Builder from(ConversationPart var1);
    }
}

