/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.rxjava3;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.ReactiveSupport;
import io.jooby.Route;
import io.jooby.internal.rxjava3.RxObserver;
import io.jooby.internal.rxjava3.RxSubscriber;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;

public class Reactivex {
    private static final Route.Filter RX = new Route.Reactive(){

        public Route.Handler apply(@NonNull Route.Handler next) {
            return ctx -> {
                Object result = next.apply(ctx);
                if (ctx.isResponseStarted()) {
                    return ctx;
                }
                if (result instanceof Flowable) {
                    Flowable flow = (Flowable)result;
                    flow.subscribe(FlowAdapters.toSubscriber((Flow.Subscriber)ReactiveSupport.newSubscriber((Context)ctx)));
                    return ctx;
                }
                if (result instanceof Single) {
                    Single single = (Single)result;
                    single.subscribe((SingleObserver)new RxSubscriber(ctx));
                    return ctx;
                }
                if (result instanceof Observable) {
                    Observable observable = (Observable)result;
                    observable.subscribe((Observer)new RxObserver(ReactiveSupport.newSubscriber((Context)ctx)));
                    return ctx;
                }
                if (result instanceof Maybe) {
                    Maybe maybe = (Maybe)result;
                    maybe.subscribe((MaybeObserver)new RxSubscriber(ctx));
                    return ctx;
                }
                if (result instanceof Disposable) {
                    return ctx;
                }
                return result;
            };
        }

        public void setRoute(Route route) {
            route.setNonBlocking(true);
        }
    };

    public static Route.Filter rx() {
        return RX;
    }

    public static Route.Handler rx(Route.Handler next) {
        return RX.then(next);
    }
}

