/*
 * Decompiled with CFR 0.152.
 */
package io.rdapapi.client.responses;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.rdapapi.client.responses.Dates;
import io.rdapapi.client.responses.Entities;
import io.rdapapi.client.responses.Meta;
import io.rdapapi.client.responses.Registrar;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class DomainResponse {
    private String domain;
    private String unicodeName;
    private String handle;
    private List<String> status;
    private Registrar registrar;
    private Dates dates;
    private List<String> nameservers;
    private boolean dnssec;
    private Entities entities;
    private Meta meta;

    private DomainResponse() {
    }

    DomainResponse(String domain, String unicodeName, String handle, List<String> status, Registrar registrar, Dates dates, List<String> nameservers, boolean dnssec, Entities entities, Meta meta) {
        this.domain = domain;
        this.unicodeName = unicodeName;
        this.handle = handle;
        this.status = status;
        this.registrar = registrar;
        this.dates = dates;
        this.nameservers = nameservers;
        this.dnssec = dnssec;
        this.entities = entities;
        this.meta = meta;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUnicodeName() {
        return this.unicodeName;
    }

    public String getHandle() {
        return this.handle;
    }

    public List<String> getStatus() {
        return this.status != null ? Collections.unmodifiableList(this.status) : Collections.emptyList();
    }

    public Registrar getRegistrar() {
        return this.registrar;
    }

    public Dates getDates() {
        return this.dates;
    }

    public List<String> getNameservers() {
        return this.nameservers != null ? Collections.unmodifiableList(this.nameservers) : Collections.emptyList();
    }

    public boolean isDnssec() {
        return this.dnssec;
    }

    public Entities getEntities() {
        return this.entities;
    }

    public Meta getMeta() {
        return this.meta;
    }

    void setMeta(Meta meta) {
        this.meta = meta;
    }
}

