/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.testing.runner;

import io.split.client.testing.SplitClientForTest;
import io.split.client.testing.annotations.SplitTestClient;
import io.split.client.testing.runner.Scenario;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.junit.runners.model.Statement;

public class RunWithSplits
extends Statement {
    private final Object target;
    private final Scenario scenario;
    private final Statement next;

    public RunWithSplits(Scenario scenario, Object target, Statement next) {
        this.scenario = scenario;
        this.target = target;
        this.next = next;
    }

    public void evaluate() throws Throwable {
        SplitClientForTest splitClient = RunWithSplits.findFirstSplitClient(this.target, this.target.getClass());
        HashMap<String, String> priorTests = new HashMap<String, String>(splitClient.tests());
        if (this.scenario != null) {
            this.scenario.apply(splitClient);
        }
        try {
            this.next.evaluate();
        }
        finally {
            splitClient.clearTreatments();
            splitClient.registerTreatments(priorTests);
        }
    }

    private static SplitClientForTest findFirstSplitClient(Object target, Class<?> type) throws IllegalAccessException {
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(SplitTestClient.class) || !field.getType().isAssignableFrom(SplitClientForTest.class)) continue;
            field.setAccessible(true);
            if (!(field.get(target) instanceof SplitClientForTest)) continue;
            return (SplitClientForTest)field.get(target);
        }
        if (type.getSuperclass() != null) {
            return RunWithSplits.findFirstSplitClient(target, type.getSuperclass());
        }
        throw new IllegalArgumentException("No SplitTestClient found in hierarchy");
    }
}

