/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import io.spring.javaformat.eclipse.projectsettings.ProjectProperties;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFile;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFiles;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFilesLocator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.util.Properties;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ProjectPropertiesTests {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void addFromFolderAddsEclipseProperties() throws IOException {
        File folder = this.temp.newFolder();
        File file = new File(folder, "eclipse.properties");
        this.writeProperties(file, "2018");
        ProjectProperties properties = new ProjectProperties();
        properties.addFromFolder(folder);
        Assertions.assertThat((String)properties.get("copyright-year")).isEqualTo((Object)"2018");
    }

    @Test
    public void addFromFolderWhenAlreadySetDoesNotOverwrite() throws IOException {
        ProjectProperties properties = new ProjectProperties();
        File folder = this.temp.newFolder();
        this.writeProperties(new File(folder, "eclipse.properties"), "2018");
        properties.addFromFolder(folder);
        folder = this.temp.newFolder();
        this.writeProperties(new File(folder, "eclipse.properties"), "2017");
        properties.addFromFolder(folder);
        Assertions.assertThat((String)properties.get("copyright-year")).isEqualTo((Object)"2018");
    }

    @Test
    public void addFromEmptyFolderUsesDefaults() throws IOException {
        ProjectProperties properties = new ProjectProperties();
        File folder = this.temp.newFolder();
        properties.addFromFolder(folder);
        String currentYear = String.valueOf(LocalDate.now().getYear());
        Assertions.assertThat((String)properties.get("copyright-year")).isEqualTo((Object)currentYear);
    }

    @Test
    public void getModifiedContentReplacesCopyrightYear() throws IOException {
        File folder = this.temp.newFolder();
        File file = new File(folder, "eclipse.properties");
        this.writeProperties(file, "2016-2020");
        ProjectProperties properties = new ProjectProperties();
        properties.addFromFolder(folder);
        ProjectSettingsFiles files = new ProjectSettingsFilesLocator(new File[0]).locateSettingsFiles();
        ProjectSettingsFile prefs = this.getFile(files, "org.eclipse.jdt.ui.prefs");
        String content = this.loadContent(properties.getModifiedContent(prefs));
        Assertions.assertThat((String)content).contains(new CharSequence[]{"Copyright 2016-2020 the original author or authors"});
    }

    private ProjectSettingsFile getFile(ProjectSettingsFiles files, String name) {
        for (ProjectSettingsFile candidate : files) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        throw new IllegalStateException("No file " + name);
    }

    private void writeProperties(File file, String copyrightYear) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("copyright-year", copyrightYear);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            properties.store(outputStream, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String loadContent(InputStream stream) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            return reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

