/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFile;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFiles;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFilesLocator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ProjectSettingsFilesLocatorTests {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void locateSettingsFilesWhenNoFoldersShouldReturnDefault() throws IOException {
        ProjectSettingsFiles files = new ProjectSettingsFilesLocator(new File[0]).locateSettingsFiles();
        Assertions.assertThat((Iterator)files.iterator()).extracting(ProjectSettingsFile::getName).containsOnly((Object[])new String[]{"org.eclipse.jdt.core.prefs", "org.eclipse.jdt.ui.prefs"});
    }

    @Test
    public void locateSettingsFilesOnlyFindPrefs() throws Exception {
        File folder = this.temp.newFolder();
        this.writeFile(folder, "foo.prefs");
        this.writeFile(folder, "bar.notprefs");
        ProjectSettingsFiles files = new ProjectSettingsFilesLocator(new File[]{folder}).locateSettingsFiles();
        Assertions.assertThat((Iterator)files.iterator()).extracting(ProjectSettingsFile::getName).containsOnly((Object[])new String[]{"org.eclipse.jdt.core.prefs", "org.eclipse.jdt.ui.prefs", "foo.prefs"});
    }

    @Test
    public void locateSettingsFilesWhenMultipleFoldersFindsInEarliest() throws Exception {
        File folder1 = this.temp.newFolder();
        this.writeFile(folder1, "foo.prefs", "foo1");
        File folder2 = this.temp.newFolder();
        this.writeFile(folder2, "foo.prefs", "foo2");
        this.writeFile(folder2, "org.eclipse.jdt.core.prefs", "core2");
        ProjectSettingsFiles files = new ProjectSettingsFilesLocator(new File[]{folder1, folder2}).locateSettingsFiles();
        LinkedHashMap found = new LinkedHashMap();
        files.iterator().forEachRemaining(f -> {
            ProjectSettingsFile projectSettingsFile = found.put(f.getName(), f);
        });
        Assertions.assertThat((InputStream)((ProjectSettingsFile)found.get("foo.prefs")).getContent()).hasSameContentAs((InputStream)new ByteArrayInputStream("foo1".getBytes()));
        Assertions.assertThat((InputStream)((ProjectSettingsFile)found.get("org.eclipse.jdt.core.prefs")).getContent()).hasSameContentAs((InputStream)new ByteArrayInputStream("core2".getBytes()));
    }

    private void writeFile(File folder, String name) throws IOException {
        this.writeFile(folder, name, name);
    }

    private void writeFile(File folder, String name, String content) throws IOException {
        File eclipseFolder = new File(folder, ".eclipse");
        if (!eclipseFolder.exists()) {
            eclipseFolder.mkdirs();
        }
        File file = new File(eclipseFolder, name);
        Throwable throwable = null;
        Object var7_8 = null;
        try (PrintWriter writer = new PrintWriter(file);){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

