/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import io.spring.javaformat.config.IndentationStyle;
import io.spring.javaformat.config.JavaBaseline;
import io.spring.javaformat.config.JavaFormatConfig;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFile;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFiles;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFilesLocator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ProjectSettingsFilesLocatorTests {
    @TempDir
    public File temp;

    @Test
    public void locateSettingsFilesWhenNoFoldersShouldReturnDefault() throws IOException {
        ProjectSettingsFiles files = new ProjectSettingsFilesLocator(new File[0]).locateSettingsFiles();
        Assertions.assertThat((Iterator)files.iterator()).extracting(ProjectSettingsFile::getName).containsOnly((Object[])new String[]{"org.eclipse.jdt.core.prefs", "org.eclipse.jdt.ui.prefs"});
    }

    @Test
    public void locateSettingsFilesOnlyFindPrefs() throws Exception {
        this.writeFile(this.temp, "foo.prefs");
        this.writeFile(this.temp, "bar.notprefs");
        ProjectSettingsFiles files = new ProjectSettingsFilesLocator(new File[]{this.temp}).locateSettingsFiles();
        Assertions.assertThat((Iterator)files.iterator()).extracting(ProjectSettingsFile::getName).containsOnly((Object[])new String[]{"org.eclipse.jdt.core.prefs", "org.eclipse.jdt.ui.prefs", "foo.prefs"});
    }

    @Test
    public void locateSettingsFilesWhenMultipleFoldersFindsInEarliest() throws Exception {
        File folder1 = new File(this.temp, "1");
        this.writeFile(folder1, "foo.prefs", "foo1");
        File folder2 = new File(this.temp, "2");
        this.writeFile(folder2, "foo.prefs", "foo2");
        this.writeFile(folder2, "org.eclipse.jdt.core.prefs", "core2");
        ProjectSettingsFiles files = new ProjectSettingsFilesLocator(new File[]{folder1, folder2}).locateSettingsFiles();
        LinkedHashMap found = new LinkedHashMap();
        files.iterator().forEachRemaining(f -> {
            ProjectSettingsFile projectSettingsFile = found.put(f.getName(), f);
        });
        Assertions.assertThat((InputStream)((ProjectSettingsFile)found.get("foo.prefs")).getContent(JavaFormatConfig.DEFAULT)).hasSameContentAs((InputStream)new ByteArrayInputStream("foo1".getBytes()));
        Assertions.assertThat((InputStream)((ProjectSettingsFile)found.get("org.eclipse.jdt.core.prefs")).getContent(JavaFormatConfig.DEFAULT)).hasSameContentAs((InputStream)new ByteArrayInputStream("core2".getBytes()));
    }

    @Test
    public void jdtCorePrefsFormatterWhenDefaultShouldUseTabs() throws IOException {
        ProjectSettingsFiles files = new ProjectSettingsFilesLocator(new File[0]).locateSettingsFiles();
        ProjectSettingsFile file = this.get(files, "org.eclipse.jdt.core.prefs");
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream content = file.getContent(JavaFormatConfig.DEFAULT);){
            Properties properties = new Properties();
            properties.load(content);
            Assertions.assertThat((Object)properties.get("org.eclipse.jdt.core.javaFormatter")).isEqualTo((Object)"io.spring.javaformat.eclipse.formatter.jdk11.tabs");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void jdtCorePrefsFormatterWhenSpacesShouldUseSpaces() throws IOException {
        ProjectSettingsFiles files = new ProjectSettingsFilesLocator(new File[0]).locateSettingsFiles();
        ProjectSettingsFile file = this.get(files, "org.eclipse.jdt.core.prefs");
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream content = file.getContent(JavaFormatConfig.of((JavaBaseline)JavaBaseline.V8, (IndentationStyle)IndentationStyle.SPACES));){
            Properties properties = new Properties();
            properties.load(content);
            Assertions.assertThat((Object)properties.get("org.eclipse.jdt.core.javaFormatter")).isEqualTo((Object)"io.spring.javaformat.eclipse.formatter.jdk8.spaces");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ProjectSettingsFile get(ProjectSettingsFiles files, String name) {
        for (ProjectSettingsFile file : files) {
            if (!file.getName().equals(name)) continue;
            return file;
        }
        return null;
    }

    private void writeFile(File folder, String name) throws IOException {
        this.writeFile(folder, name, name);
    }

    private void writeFile(File folder, String name, String content) throws IOException {
        File eclipseFolder = new File(folder, ".eclipse");
        if (!eclipseFolder.exists()) {
            eclipseFolder.mkdirs();
        }
        File file = new File(eclipseFolder, name);
        Throwable throwable = null;
        Object var7_8 = null;
        try (PrintWriter writer = new PrintWriter(file);){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

