/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.gradle;

import io.spring.javaformat.eclipse.Executor;
import io.spring.javaformat.eclipse.Messages;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFilesLocator;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.InternalGradleWorkspace;
import org.eclipse.buildship.core.internal.workspace.ModelProviderUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class RefreshProjectsSettingsJob
extends Job {
    private static final Object TASK_NAME = "checkFormatMain";
    private final CancellationTokenSource tokenSource = GradleConnector.newCancellationTokenSource();

    public RefreshProjectsSettingsJob() {
        super("Refresh spring-javaformat project settings");
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            new Executor(Messages.springFormatSettingsImportError).run(() -> this.configureProjects(monitor));
        }
        catch (CoreException ex) {
            return ex.getStatus();
        }
        return Status.OK_STATUS;
    }

    private void configureProjects(IProgressMonitor monitor) throws CoreException, IOException {
        InternalGradleWorkspace workspace = CorePlugin.internalGradleWorkspace();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            Optional build = workspace.getBuild(project);
            if (build.isPresent()) {
                this.configureProject(project, (InternalGradleBuild)build.get(), monitor);
            }
            ++n2;
        }
    }

    private void configureProject(IProject project, InternalGradleBuild build, IProgressMonitor monitor) throws CoreException, IOException {
        Set projects = ModelProviderUtil.fetchAllEclipseProjects((InternalGradleBuild)build, (CancellationTokenSource)this.tokenSource, (FetchStrategy)FetchStrategy.FORCE_RELOAD, (IProgressMonitor)monitor);
        if (this.hasSpringFormatPlugin(projects)) {
            ProjectSettingsFilesLocator locator = new ProjectSettingsFilesLocator(this.getSearchFolders(projects));
            locator.locateSettingsFiles().applyToProject(project, monitor);
        }
    }

    private boolean hasSpringFormatPlugin(Set<EclipseProject> projects) {
        for (EclipseProject project : projects) {
            for (GradleTask task : project.getGradleProject().getTasks()) {
                if (!this.isSpringFormatPlugin(task)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpringFormatPlugin(GradleTask task) {
        return TASK_NAME.equals(task.getName());
    }

    private Set<File> getSearchFolders(Set<EclipseProject> projects) {
        LinkedHashSet<File> searchFolders = new LinkedHashSet<File>();
        for (EclipseProject project : projects) {
            while (project != null) {
                searchFolders.add(project.getProjectDirectory());
                project = project.getParent();
            }
        }
        return searchFolders;
    }
}

