/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.gradle;

import io.spring.javaformat.eclipse.Executor;
import io.spring.javaformat.eclipse.Messages;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFilesLocator;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.InternalGradleWorkspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class RefreshProjectsSettingsJob
extends Job {
    private static final Object TASK_NAME = "checkFormatMain";
    private final CancellationTokenSource tokenSource = GradleConnector.newCancellationTokenSource();
    private final Set<IProject> projects;

    public RefreshProjectsSettingsJob() {
        this(null);
    }

    public RefreshProjectsSettingsJob(Set<IProject> projects) {
        super("Refresh spring-javaformat project settings");
        this.projects = projects;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            new Executor(Messages.springFormatSettingsImportError).run(() -> this.configureProjects(monitor));
        }
        catch (CoreException ex) {
            return ex.getStatus();
        }
        return Status.OK_STATUS;
    }

    private void configureProjects(IProgressMonitor monitor) throws CoreException, IOException {
        InternalGradleWorkspace workspace = CorePlugin.internalGradleWorkspace();
        Collection<IProject> projects = this.projects;
        if (projects == null) {
            projects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        }
        for (IProject project : projects) {
            Optional build = workspace.getBuild(project);
            if (!build.isPresent()) continue;
            this.configureProject(project, (InternalGradleBuild)build.get(), monitor);
        }
    }

    private void configureProject(IProject project, InternalGradleBuild build, IProgressMonitor monitor) throws CoreException, IOException {
        Collection projects = build.getModelProvider().fetchEclipseProjectAndRunSyncTasks(this.tokenSource, monitor);
        if (this.hasSpringFormatPlugin(projects)) {
            ProjectSettingsFilesLocator locator = new ProjectSettingsFilesLocator(this.getSearchFolders(projects));
            locator.locateSettingsFiles().applyToProject(project, monitor);
        }
    }

    private boolean hasSpringFormatPlugin(Collection<EclipseProject> projects) {
        for (EclipseProject project : projects) {
            for (GradleTask task : project.getGradleProject().getTasks()) {
                if (!this.isSpringFormatPlugin(task)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpringFormatPlugin(GradleTask task) {
        return TASK_NAME.equals(task.getName());
    }

    private Set<File> getSearchFolders(Collection<EclipseProject> projects) {
        LinkedHashSet<File> searchFolders = new LinkedHashSet<File>();
        for (EclipseProject project : projects) {
            while (project != null) {
                searchFolders.add(project.getProjectDirectory());
                project = project.getParent();
            }
        }
        return searchFolders;
    }
}

