/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import io.spring.javaformat.config.JavaFormatConfig;
import io.spring.javaformat.eclipse.projectsettings.ProjectProperties;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProjectSettingsFiles
implements Iterable<ProjectSettingsFile> {
    private final List<ProjectSettingsFile> files;
    private final ProjectProperties projectProperties;

    public ProjectSettingsFiles(Collection<ProjectSettingsFile> files, ProjectProperties projectProperties) {
        this.files = new ArrayList<ProjectSettingsFile>(files);
        this.projectProperties = projectProperties;
    }

    @Override
    public Iterator<ProjectSettingsFile> iterator() {
        return this.files.iterator();
    }

    public void applyToProject(IProject project, IProgressMonitor monitor) throws IOException, CoreException {
        JavaFormatConfig javaFormatConfig = this.getJavaFormatConfig(project);
        for (ProjectSettingsFile file : this) {
            file = this.projectProperties.getModifiedContent(file);
            IFile destination = project.getFile(".settings/" + file.getName());
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream content = file.getContent(javaFormatConfig);){
                if (!destination.exists()) {
                    destination.create((InputStream)new BufferedInputStream(content), true, monitor);
                    continue;
                }
                destination.setContents((InputStream)new BufferedInputStream(content), 1, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private JavaFormatConfig getJavaFormatConfig(IProject project) {
        try {
            IPath location = project.getLocation();
            File file = location != null ? location.toFile() : null;
            return JavaFormatConfig.findFrom((File)file);
        }
        catch (Exception exception) {
            return JavaFormatConfig.DEFAULT;
        }
    }
}

