/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.gradle;

import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFilesLocator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.buildship.core.InitializationContext;
import org.eclipse.buildship.core.ProjectConfigurator;
import org.eclipse.buildship.core.ProjectContext;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.InternalGradleWorkspace;
import org.eclipse.buildship.core.internal.workspace.ModelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class GradleProjectSettingsConfigurator
implements ProjectConfigurator {
    private static final Object TASK_NAME = "checkFormatMain";
    private CancellationTokenSource tokenSource;

    public void init(InitializationContext context, IProgressMonitor monitor) {
        this.tokenSource = GradleConnector.newCancellationTokenSource();
    }

    public void configure(ProjectContext context, IProgressMonitor monitor) {
        try {
            this.configureProject(context.getProject(), monitor);
        }
        catch (Exception ex) {
            context.error("Failed to apply project settings", ex);
        }
    }

    private void configureProject(IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        ModelProvider modelProvider;
        Collection<EclipseProject> rootProjects;
        EclipseProject eclipseProject;
        InternalGradleWorkspace workspace = CorePlugin.internalGradleWorkspace();
        Optional build = workspace.getBuild(project);
        if (build.isPresent() && this.hasSpringFormatPlugin(eclipseProject = this.findProjectByName(rootProjects = this.getRootProjects(monitor, modelProvider = ((InternalGradleBuild)build.get()).getModelProvider()), project.getName()))) {
            ProjectSettingsFilesLocator locator = new ProjectSettingsFilesLocator(this.getSearchFolders(rootProjects));
            locator.locateSettingsFiles().applyToProject(project, monitor);
        }
    }

    private Collection<EclipseProject> getRootProjects(IProgressMonitor monitor, ModelProvider modelProvider) {
        Map models = modelProvider.fetchModels(EclipseProject.class, FetchStrategy.FORCE_RELOAD, this.tokenSource, monitor);
        return (Collection)(models instanceof Map ? models.values() : models);
    }

    private EclipseProject findProjectByName(Iterable<? extends EclipseProject> candidates, String name) {
        for (EclipseProject eclipseProject : candidates) {
            if (name.equals(eclipseProject.getName())) {
                return eclipseProject;
            }
            EclipseProject childResult = this.findProjectByName((Iterable<? extends EclipseProject>)eclipseProject.getChildren(), name);
            if (childResult == null) continue;
            return childResult;
        }
        return null;
    }

    private boolean hasSpringFormatPlugin(EclipseProject eclipseProject) {
        if (eclipseProject != null) {
            for (GradleTask task : eclipseProject.getGradleProject().getTasks()) {
                if (!this.isSpringFormatPlugin(task)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpringFormatPlugin(GradleTask task) {
        return TASK_NAME.equals(task.getName());
    }

    private Set<File> getSearchFolders(Collection<EclipseProject> projects) {
        LinkedHashSet<File> searchFolders = new LinkedHashSet<File>();
        for (EclipseProject project : projects) {
            while (project != null) {
                searchFolders.add(project.getProjectDirectory());
                project = project.getParent();
            }
        }
        return searchFolders;
    }

    public void unconfigure(ProjectContext context, IProgressMonitor monitor) {
    }
}

