/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import io.spring.javaformat.config.JavaFormatConfig;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;

final class ProjectSettingsFile {
    private final String name;
    private final ContentSupplier contentSupplier;

    ProjectSettingsFile(String name, ContentSupplier contentSupplier) {
        this.name = name;
        this.contentSupplier = contentSupplier;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getContent(JavaFormatConfig javaFormatConfig) throws IOException {
        return this.contentSupplier.getContent(javaFormatConfig);
    }

    public ProjectSettingsFile withUpdatedContent(BiFunction<JavaFormatConfig, String, String> operation) {
        return new ProjectSettingsFile(this.name, javaFormatConfig -> {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.contentSupplier.getContent(javaFormatConfig)));){
                StringWriter writer = new StringWriter();
                char[] buffer = new char[4096];
                int read = 0;
                while ((read = reader.read(buffer)) >= 0) {
                    writer.write(buffer, 0, read);
                }
                String content = (String)operation.apply(javaFormatConfig, writer.toString());
                return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    public static ProjectSettingsFile fromFile(File file) {
        return new ProjectSettingsFile(file.getName(), javaFormatConfig -> new FileInputStream(file));
    }

    public static ProjectSettingsFile fromClasspath(Class<?> sourceClass, String name) {
        return new ProjectSettingsFile(name, javaFormatConfig -> sourceClass.getResourceAsStream(name));
    }

    @FunctionalInterface
    static interface ContentSupplier {
        public InputStream getContent(JavaFormatConfig var1) throws IOException;
    }
}

