/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

class ProjectProperties {
    private static final String COPYRIGHT_YEAR = "copyright-year";
    private static final DateTimeFormatter YEAR_FORMATTER = DateTimeFormatter.ofPattern("yyyy");
    private static final Map<String, Supplier<String>> DEFAULTS;
    private Map<String, String> properties = new HashMap<String, String>();

    static {
        HashMap<String, Supplier<String>> defaults = new HashMap<String, Supplier<String>>();
        defaults.put(COPYRIGHT_YEAR, () -> LocalDateTime.now().format(YEAR_FORMATTER));
        DEFAULTS = Collections.unmodifiableMap(defaults);
    }

    ProjectProperties() {
    }

    public void addFromFolder(File folder) throws IOException {
        File file = new File(folder, "eclipse.properties");
        if (file.exists()) {
            this.addFromFile(file);
        }
    }

    private void addFromFile(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(inputStream);
            this.addFromProperties(properties);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addFromProperties(Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.properties.putIfAbsent(key.toString(), value.toString())));
    }

    public ProjectSettingsFile getModifiedContent(ProjectSettingsFile file) throws IOException {
        if (file.getName().equals("org.eclipse.jdt.ui.prefs")) {
            return file.withUpdatedContent((javaFormatConfig, content) -> content.replace("Copyright the original author or authors", "Copyright " + this.get(COPYRIGHT_YEAR) + " the original author or authors"));
        }
        return file;
    }

    String get(String name) {
        String value = this.properties.get(name);
        return value != null ? value : DEFAULTS.getOrDefault(name, () -> null).get();
    }
}

