/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpringJavadocCheck
extends AbstractSpringCheck {
    private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("@param\\s+\\S+\\s+(.*)"), Pattern.compile("@throws\\s+\\S+\\s+(.*)"), Pattern.compile("@return\\s+(.*)")};

    @Override
    public int[] getDefaultTokens() {
        return new int[]{15, 14, 154, 157, 9, 8};
    }

    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157, 9, 8, 155, 161};
    }

    public void visitToken(DetailAST ast) {
        int lineNumber = ast.getLineNo();
        TextBlock javadoc = this.getFileContents().getJavadocBefore(lineNumber);
        if (javadoc != null) {
            this.checkParamTags(javadoc);
        }
    }

    private void checkParamTags(TextBlock javadoc) {
        String[] text = javadoc.getText();
        for (int i = 0; i < text.length; ++i) {
            for (Pattern pattern : PATTERNS) {
                String description;
                Matcher matcher = pattern.matcher(text[i]);
                if (!matcher.find() || !this.startsWithUppercase(description = matcher.group(1).trim())) continue;
                this.log(javadoc.getStartLineNo() + i, text[i].length() - description.length(), "javadoc.badCase", new Object[0]);
            }
        }
    }

    private boolean startsWithUppercase(String description) {
        return description.length() > 0 && Character.isUpperCase(description.charAt(0));
    }
}

