/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpringJavadocCheck
extends AbstractSpringCheck {
    private static final Pattern[] CASE_CHECKED_TAG_PATTERNS = new Pattern[]{Pattern.compile("@param\\s+\\S+\\s+(.*)"), Pattern.compile("@throws\\s+\\S+\\s+(.*)"), Pattern.compile("@return\\s+(.*)")};
    private static final Pattern SINCE_TAG_PATTERN = Pattern.compile("@since\\s+(.*)");
    private static final Set<Integer> TOP_LEVEL_TYPES;
    private boolean requireSinceTag;
    private boolean publicOnlySinceTags;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{15, 14, 154, 157, 9, 8};
    }

    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157, 9, 8, 155, 161};
    }

    public void visitToken(DetailAST ast) {
        int lineNumber = ast.getLineNo();
        TextBlock javadoc = this.getFileContents().getJavadocBefore(lineNumber);
        if (javadoc != null) {
            this.checkTagCase(ast, javadoc);
            this.checkSinceTag(ast, javadoc);
        }
    }

    private void checkTagCase(DetailAST ast, TextBlock javadoc) {
        String[] text = javadoc.getText();
        for (int i = 0; i < text.length; ++i) {
            for (Pattern pattern : CASE_CHECKED_TAG_PATTERNS) {
                String description;
                Matcher matcher = pattern.matcher(text[i]);
                if (!matcher.find() || !this.startsWithUppercase(description = matcher.group(1).trim())) continue;
                this.log(javadoc.getStartLineNo() + i, text[i].length() - description.length(), "javadoc.badCase", new Object[0]);
            }
        }
    }

    private void checkSinceTag(DetailAST ast, TextBlock javadoc) {
        if (!TOP_LEVEL_TYPES.contains(ast.getType())) {
            return;
        }
        String[] text = javadoc.getText();
        DetailAST modifiers = ast.findFirstToken(5);
        boolean privateType = modifiers.findFirstToken(62) == null && modifiers.findFirstToken(63) == null;
        boolean innerType = ast.getParent() != null;
        boolean found = false;
        for (int i = 0; i < text.length; ++i) {
            Matcher matcher = SINCE_TAG_PATTERN.matcher(text[i]);
            if (!matcher.find()) continue;
            found = true;
            String description = matcher.group(1).trim();
            if (!this.publicOnlySinceTags || !privateType) continue;
            this.log(javadoc.getStartLineNo() + i, text[i].length() - description.length(), "javadoc.publicSince", new Object[0]);
        }
        if (!(!this.requireSinceTag || innerType || found || this.publicOnlySinceTags && privateType)) {
            this.log(javadoc.getStartLineNo(), 0, "javadoc.missingSince", new Object[0]);
        }
    }

    private boolean startsWithUppercase(String description) {
        return description.length() > 0 && Character.isUpperCase(description.charAt(0));
    }

    public void setRequireSinceTag(boolean requireSinceTag) {
        this.requireSinceTag = requireSinceTag;
    }

    public void setPublicOnlySinceTags(boolean publicOnlySinceTags) {
        this.publicOnlySinceTags = publicOnlySinceTags;
    }

    static {
        HashSet<Integer> topLevelTypes = new HashSet<Integer>();
        topLevelTypes.add(15);
        topLevelTypes.add(14);
        topLevelTypes.add(154);
        topLevelTypes.add(157);
        TOP_LEVEL_TYPES = Collections.unmodifiableSet(topLevelTypes);
    }
}

