/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.filter;

import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import java.util.Set;
import java.util.SortedSet;

public class CheckFilter
extends AbstractCheck {
    private Context childContext;
    private AbstractCheck check;

    public void finishLocalSetup() {
        DefaultContext context = new DefaultContext();
        context.add("severity", (Object)this.getSeverity());
        context.add("tabWidth", (Object)String.valueOf(this.getTabWidth()));
        this.childContext = context;
    }

    public void setupChild(Configuration childConf) throws CheckstyleException {
        String name;
        ModuleFactory moduleFactory = this.createModuleFactory();
        Object module = moduleFactory.createModule(name = childConf.getName());
        if (!(module instanceof AbstractCheck)) {
            throw new CheckstyleException("OptionalCheck is not allowed as a parent of " + name + " Please review 'Parent Module' section for this Check.");
        }
        if (this.check != null) {
            throw new CheckstyleException("Can only make a single check optional");
        }
        AbstractCheck check = (AbstractCheck)module;
        check.contextualize(this.childContext);
        check.configure(childConf);
        check.init();
        this.check = check;
    }

    private ModuleFactory createModuleFactory() {
        try {
            ClassLoader classLoader = AbstractCheck.class.getClassLoader();
            Set packageNames = PackageNamesLoader.getPackageNames((ClassLoader)classLoader);
            return new PackageObjectFactory(packageNames, classLoader);
        }
        catch (CheckstyleException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public int[] getDefaultTokens() {
        return this.check.getDefaultTokens();
    }

    public int[] getAcceptableTokens() {
        return this.check.getAcceptableTokens();
    }

    public int[] getRequiredTokens() {
        return this.check.getRequiredTokens();
    }

    public boolean isCommentNodesRequired() {
        return this.check.isCommentNodesRequired();
    }

    public SortedSet<LocalizedMessage> getMessages() {
        return this.check.getMessages();
    }

    public void beginTree(DetailAST rootAST) {
        this.check.setFileContents(this.getFileContents());
        this.check.clearMessages();
        this.check.beginTree(rootAST);
    }

    public void finishTree(DetailAST rootAST) {
        this.check.finishTree(rootAST);
    }

    public void visitToken(DetailAST ast) {
        this.check.visitToken(ast);
    }

    public void leaveToken(DetailAST ast) {
        this.check.leaveToken(ast);
    }
}

