/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle;

import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import io.spring.javaformat.checkstyle.FilteredModuleFactory;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.xml.sax.InputSource;

class SpringConfigurationLoader {
    private final Context context;
    private final FilteredModuleFactory moduleFactory;

    SpringConfigurationLoader(Context context, FilteredModuleFactory moduleFactory) {
        this.context = context;
        this.moduleFactory = moduleFactory;
    }

    public Collection<FileSetCheck> load(PropertyResolver propertyResolver) {
        Configuration config = this.loadConfiguration(this.getClass().getResourceAsStream("spring-checkstyle.xml"), propertyResolver);
        return Arrays.stream(config.getChildren()).filter(this.moduleFactory::nonFiltered).map(this::load).collect(Collectors.toList());
    }

    private Configuration loadConfiguration(InputStream inputStream, PropertyResolver propertyResolver) {
        try {
            InputSource inputSource = new InputSource(inputStream);
            return ConfigurationLoader.loadConfiguration((InputSource)inputSource, (PropertyResolver)propertyResolver, (ConfigurationLoader.IgnoredModulesOptions)ConfigurationLoader.IgnoredModulesOptions.EXECUTE);
        }
        catch (CheckstyleException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private FileSetCheck load(Configuration configuration) {
        Object module = this.createModule(configuration);
        if (!(module instanceof FileSetCheck)) {
            throw new IllegalStateException(configuration.getName() + " is not allowed");
        }
        return (FileSetCheck)module;
    }

    private Object createModule(Configuration configuration) {
        String name = configuration.getName();
        try {
            Object module = this.moduleFactory.createModule(name);
            if (module instanceof AutomaticBean) {
                this.initialize(configuration, (AutomaticBean)module);
            }
            return module;
        }
        catch (CheckstyleException ex) {
            throw new IllegalStateException("cannot initialize module " + name + " - " + ex.getMessage(), ex);
        }
    }

    private void initialize(Configuration configuration, AutomaticBean bean) throws CheckstyleException {
        bean.contextualize(this.context);
        bean.configure(configuration);
    }
}

