/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class SpringHeaderCheck
extends AbstractFileSetCheck {
    private static final String UNCHECKED = "unchecked";
    public static final String DEFAULT_HEADER_TYPE = "apache2";
    public static final String DEFAULT_HEADER_COPYRIGHT_PATTERN = "20\\d\\d-20\\d\\d";
    private String headerType = "apache2";
    private String headerCopyrightPattern = "20\\d\\d-20\\d\\d";
    private List<Pattern> headerLines;

    protected void finishLocalSetup() throws CheckstyleException {
        try {
            this.headerLines = this.loadHeaderLines();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Pattern> loadHeaderLines() throws IOException {
        if (UNCHECKED.equals(this.headerType)) {
            return null;
        }
        String name = "header-" + this.headerType + ".txt";
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        if (inputStream == null) {
            throw new IllegalStateException("Unknown header type " + this.headerType);
        }
        inputStream = new BufferedInputStream(inputStream);
        try (InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");){
            LineNumberReader lineReader = new LineNumberReader(reader);
            ArrayList<Pattern> lines = new ArrayList<Pattern>();
            while (true) {
                String line;
                if ((line = lineReader.readLine()) == null) {
                    ArrayList<Pattern> arrayList = lines;
                    return arrayList;
                }
                lines.add(this.loadHeaderLine(line));
                continue;
                break;
            }
        }
    }

    private Pattern loadHeaderLine(String line) {
        line = line.replace("${copyright-pattern}", "\\E" + this.headerCopyrightPattern + "\\Q");
        line = "^\\Q" + line + "\\E$";
        return Pattern.compile(line);
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        if (UNCHECKED.equals(this.headerType)) {
            return;
        }
        if (this.headerLines.size() > fileText.size()) {
            this.log(1, "header.missing", new Object[0]);
            return;
        }
        for (int i = 0; i < this.headerLines.size(); ++i) {
            String fileLine = fileText.get(i);
            Pattern headerLine = this.headerLines.get(i);
            if (headerLine.matcher(fileLine).matches()) continue;
            this.log(i + 1, "header.mismatch", new Object[]{headerLine});
            return;
        }
    }

    public void setHeaderType(String headerType) {
        this.headerType = headerType;
    }

    public void setHeaderCopyrightPattern(String headerCopyrightPattern) {
        this.headerCopyrightPattern = headerCopyrightPattern;
    }
}

