/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter;

import io.spring.javaformat.formatter.FormatterOption;
import io.spring.javaformat.formatter.eclipse.ExtendedCodeFormatter;
import io.spring.javaformat.formatter.preparator.Preparators;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.TextEdit;

public class Formatter
extends CodeFormatter {
    private static final int DEFAULT_COMPONENTS = 4104;
    private static final int DEFAULT_INDENTATION_LEVEL = 0;
    public static final String DEFAULT_LINE_SEPARATOR = null;
    private final Set<FormatterOption> options;
    private CodeFormatter delegate = new DelegateCodeFormatter();

    public Formatter() {
        this.options = Collections.emptySet();
    }

    public Formatter(FormatterOption ... options) {
        this.options = Collections.unmodifiableSet(new HashSet<FormatterOption>(Arrays.asList(options)));
    }

    public TextEdit format(String source) {
        return this.format(source, DEFAULT_LINE_SEPARATOR);
    }

    public TextEdit format(String source, String lineSeparator) {
        return this.format(source, 0, source.length(), lineSeparator);
    }

    public TextEdit format(String source, int offset, int length) {
        return this.format(source, offset, length, DEFAULT_LINE_SEPARATOR);
    }

    public TextEdit format(String source, int offset, int length, String lineSeparator) {
        return this.format(4104, source, offset, length, 0, lineSeparator);
    }

    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        return this.nlsSafe(() -> this.delegate.format(kind, source, offset, length, indentationLevel, lineSeparator));
    }

    public TextEdit format(String source, IRegion[] regions) {
        return this.format(source, regions, DEFAULT_LINE_SEPARATOR);
    }

    public TextEdit format(String source, IRegion[] regions, String lineSeparator) {
        return this.format(4104, source, regions, 0, lineSeparator);
    }

    public TextEdit format(int kind, String source, IRegion[] regions, int indentationLevel, String lineSeparator) {
        return this.nlsSafe(() -> this.delegate.format(kind, source, regions, indentationLevel, lineSeparator));
    }

    public String createIndentationString(int indentationLevel) {
        return this.delegate.createIndentationString(indentationLevel);
    }

    public void setOptions(Map<String, String> options) {
        this.delegate.setOptions(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T nlsSafe(Supplier<T> formatted) {
        if (this.options.contains((Object)FormatterOption.SHOW_NLS_WARNINGS)) {
            return formatted.get();
        }
        String nlsWarnings = System.getProperty("osgi.nls.warnings");
        try {
            System.setProperty("osgi.nls.warnings", "ignore");
            T t = formatted.get();
            return t;
        }
        finally {
            if (nlsWarnings != null) {
                System.setProperty("osgi.nls.warnings", nlsWarnings);
            }
        }
    }

    private static class DelegateCodeFormatter
    extends ExtendedCodeFormatter {
        static Map<String, String> OPTIONS;

        DelegateCodeFormatter() {
            super(OPTIONS);
            Preparators.forEach(arg_0 -> ((DelegateCodeFormatter)this).addPreparator(arg_0));
        }

        public void setOptions(Map<String, String> options) {
            super.setOptions(OPTIONS);
        }

        static {
            try {
                Properties properties = new Properties();
                try (InputStream inputStream = Formatter.class.getResourceAsStream("formatter.prefs");){
                    properties.load(inputStream);
                    OPTIONS = Collections.unmodifiableMap(properties);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

