/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter.eclipse;

import io.spring.javaformat.config.IndentationStyle;
import io.spring.javaformat.config.JavaBaseline;
import io.spring.javaformat.config.JavaFormatConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class Options {
    private final String prefix;

    public Options(String prefix) {
        this.prefix = prefix;
    }

    public Map<String, String> load(JavaFormatConfig javaFormatConfig) {
        try {
            Map<String, String> properties = this.loadProperties();
            this.applyConfig(properties, javaFormatConfig);
            return Collections.unmodifiableMap(properties);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Map<String, String> loadProperties() throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = this.getClass().getResourceAsStream("formatter.prefs");){
            properties.load(inputStream);
        }
        LinkedHashMap<String, String> prefixedProperties = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            prefixedProperties.put(this.prefix + "." + entry.getKey(), (String)entry.getValue());
        }
        return prefixedProperties;
    }

    private void applyConfig(Map<String, String> properties, JavaFormatConfig javaFormatConfig) {
        String coreFormatter = this.prefix + ".core.formatter.";
        if (javaFormatConfig.getIndentationStyle() == IndentationStyle.SPACES) {
            properties.put(coreFormatter + "tabulation.char", "space");
        }
        if (javaFormatConfig.getJavaBaseline() == JavaBaseline.V8) {
            properties.put(coreFormatter + "insert_space_after_closing_angle_bracket_in_type_parameters", "insert");
        }
    }
}

