/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter;

import io.spring.javaformat.formatter.FileFormatterException;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.regex.Pattern;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class FileEdit {
    private static final Pattern TRAILING_WHITESPACE = Pattern.compile(" +$", 8);
    private final File file;
    private final Charset encoding;
    private final String originalContent;
    private final TextEdit edit;

    FileEdit(File file, Charset encoding, String originalContent, TextEdit edit) {
        this.file = file;
        this.encoding = encoding;
        this.originalContent = originalContent;
        this.edit = edit;
    }

    public File getFile() {
        return this.file;
    }

    public boolean hasEdits() {
        return this.edit.hasChildren() || this.edit.getLength() > 0;
    }

    public void save() {
        try {
            String formattedContent = this.getFormattedContent();
            byte[] bytes = formattedContent.getBytes(this.encoding);
            Files.write(this.file.toPath(), bytes, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception ex) {
            throw FileFormatterException.wrap(this.file, ex);
        }
    }

    public String getFormattedContent() throws Exception {
        try {
            Document document = new Document(this.originalContent);
            this.edit.apply((IDocument)document);
            String formattedContent = document.get();
            return this.trimTrailingWhitespace(formattedContent);
        }
        catch (Exception ex) {
            throw FileFormatterException.wrap(this.file, ex);
        }
    }

    private String trimTrailingWhitespace(String content) {
        return TRAILING_WHITESPACE.matcher(content).replaceAll("");
    }
}

