/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.gradle;

import io.spring.javaformat.gradle.CheckTask;
import io.spring.javaformat.gradle.FormatTask;
import io.spring.javaformat.gradle.FormatterTask;
import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class SpringJavaFormatPlugin
implements Plugin<Project> {
    private Project project;

    public void apply(Project project) {
        this.project = project;
        this.addSourceTasks();
    }

    private void addSourceTasks() {
        this.project.getPlugins().withType(JavaBasePlugin.class, plugin -> {
            Task formatAll = this.project.task("format");
            formatAll.setDescription("Apply Spring Java formatting");
            Task checkAll = this.project.task("checkFormat");
            checkAll.setDescription("Run Spring Java formatting checks");
            this.project.getTasks().getByName("check").dependsOn(new Object[]{checkAll});
            ((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> this.addSourceTasks((SourceSet)sourceSet, checkAll, formatAll));
        });
    }

    private void addSourceTasks(SourceSet sourceSet, Task checkAll, Task formatAll) {
        CheckTask checkTask = this.addSourceTask(sourceSet, CheckTask.class, "checkFormat", "Run Spring Java formatting checks");
        checkTask.setReportLocation(new File(this.project.getBuildDir(), "reports/format/" + sourceSet.getName() + "/check-format.txt"));
        checkAll.dependsOn(new Object[]{checkTask});
        FormatTask formatSourceSet = this.addSourceTask(sourceSet, FormatTask.class, "format", "Apply Spring Java formatting");
        formatSourceSet.conventionMapping("encoding", () -> "UTF-8");
        formatAll.dependsOn(new Object[]{formatSourceSet});
    }

    private <T extends FormatterTask> T addSourceTask(SourceSet sourceSet, Class<T> taskType, String name, String desc) {
        String taskName = sourceSet.getTaskName(name, null);
        FormatterTask task = (FormatterTask)this.project.getTasks().create(taskName, taskType);
        task.setDescription(desc + " for " + sourceSet.getName());
        task.setSource((FileTree)sourceSet.getAllJava());
        return (T)((Object)task);
    }
}

