/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.gradle.tasks;

import io.spring.javaformat.config.IndentationStyle;
import io.spring.javaformat.config.JavaBaseline;
import io.spring.javaformat.config.JavaFormatConfig;
import io.spring.javaformat.formatter.FileEdit;
import io.spring.javaformat.formatter.FileFormatter;
import java.nio.charset.Charset;
import java.util.stream.Stream;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;

public abstract class FormatterTask
extends SourceTask {
    private String encoding;
    private final Property<IndentationStyle> indentationStyle = this.getProject().getObjects().property(IndentationStyle.class);
    private final Property<JavaBaseline> javaBaseline = this.getProject().getObjects().property(JavaBaseline.class);

    FormatterTask() {
    }

    @Input
    @Optional
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Input
    public Property<IndentationStyle> getIndentationStyle() {
        return this.indentationStyle;
    }

    @Input
    public Property<JavaBaseline> getJavaBaseline() {
        return this.javaBaseline;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    protected final Stream<FileEdit> formatFiles() {
        JavaFormatConfig javaFormatConfig = JavaFormatConfig.of((JavaBaseline)((JavaBaseline)this.javaBaseline.get()), (IndentationStyle)((IndentationStyle)this.indentationStyle.get()));
        FileFormatter formatter = new FileFormatter(javaFormatConfig);
        Charset encoding = this.getEncoding() != null ? Charset.forName(this.getEncoding()) : Charset.defaultCharset();
        return formatter.formatFiles((Iterable)this.getSource().getFiles(), encoding);
    }
}

