/*
 * Decompiled with CFR 0.152.
 */
package io.streammachine.driver.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import io.streammachine.driver.serializer.AvroSerializer;
import io.streammachine.driver.serializer.EventSerializer;
import io.streammachine.driver.serializer.JsonSerializer;
import io.streammachine.driver.serializer.UnsupportedSerializationTypeException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;

public class SerializerProvider {
    private static final Map<String, EventSerializer> serializers = new HashMap<String, EventSerializer>();

    private SerializerProvider() {
    }

    public static EventSerializer getSerializer(String schemaId, Object schema) {
        EventSerializer existingSerializer = serializers.get(schemaId);
        if (existingSerializer == null) {
            if (schema instanceof Schema) {
                AvroSerializer serializer = new AvroSerializer((Schema)schema);
                serializers.put(schemaId, serializer);
                return serializer;
            }
            if (schema instanceof JsonNode) {
                JsonSerializer serializer = new JsonSerializer((JsonNode)schema);
                serializers.put(schemaId, serializer);
                return serializer;
            }
            throw new UnsupportedSerializationTypeException("Provided serialization type is not supported");
        }
        return existingSerializer;
    }
}

