/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

import com.oracle.libuv.Address;
import com.oracle.libuv.Handle;
import com.oracle.libuv.LoopHandle;
import com.oracle.libuv.UDPCloseCallback;
import com.oracle.libuv.UDPRecvCallback;
import com.oracle.libuv.UDPSendCallback;
import com.oracle.libuv.UdpFlags;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Objects;

public class UDPHandle
extends Handle {
    private boolean closed = false;
    private UDPRecvCallback onRecv;
    private UDPSendCallback onSend;
    private UDPCloseCallback onClose;

    public void setRecvCallback(UDPRecvCallback callback) {
        this.onRecv = callback;
    }

    public void setSendCallback(UDPSendCallback callback) {
        this.onSend = callback;
    }

    public void setCloseCallback(UDPCloseCallback callback) {
        this.onClose = callback;
    }

    UDPHandle(LoopHandle loop) {
        super(UDPHandle._new(loop.pointer()), loop);
        this._initialize(this.pointer);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this._close(this.pointer);
        }
        this.closed = true;
    }

    public Address address() {
        return this._address(this.pointer);
    }

    public int bind(int port, String address, boolean ipv6) {
        return this.bind(port, address, ipv6, EnumSet.noneOf(UdpFlags.class));
    }

    public int bind(int port, String address, boolean ipv6, EnumSet<UdpFlags> flags) {
        Objects.requireNonNull(address);
        int flagValue = 0;
        for (UdpFlags next : flags) {
            flagValue |= next.value;
        }
        return this.bind(port, address, ipv6, flagValue);
    }

    public int bind(int port, String address, boolean ipv6, int flags) {
        return this._bind(this.pointer, port, address, ipv6, flags);
    }

    public int send(String str, int port, String host, boolean ipv6) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(host);
        byte[] data = str.getBytes(StandardCharsets.UTF_8);
        return this.send(ByteBuffer.wrap(data), 0, data.length, port, host, ipv6);
    }

    public int send(String str, String encoding, int port, String host, boolean ipv6) throws UnsupportedEncodingException {
        Objects.requireNonNull(str);
        Objects.requireNonNull(encoding);
        Objects.requireNonNull(host);
        byte[] data = str.getBytes(encoding);
        return this.send(ByteBuffer.wrap(data), 0, data.length, port, host, ipv6);
    }

    public int send(ByteBuffer buffer, int port, String host, boolean ipv6) {
        Objects.requireNonNull(buffer);
        Objects.requireNonNull(host);
        return buffer.hasArray() ? this._send(this.pointer, buffer, buffer.array(), 0, buffer.capacity(), port, host, this.loop.getContext(), ipv6) : this._send(this.pointer, buffer, null, 0, buffer.capacity(), port, host, this.loop.getContext(), ipv6);
    }

    public int send(ByteBuffer buffer, int offset, int length, int port, String host, boolean ipv6) {
        Objects.requireNonNull(buffer);
        Objects.requireNonNull(host);
        return buffer.hasArray() ? this._send(this.pointer, buffer, buffer.array(), offset, length, port, host, this.loop.getContext(), ipv6) : this._send(this.pointer, buffer, null, offset, length, port, host, this.loop.getContext(), ipv6);
    }

    public int recvStart() {
        return this._recv_start(this.pointer);
    }

    public int recvStop() {
        return this._recv_stop(this.pointer);
    }

    public int setTTL(int ttl) {
        return this._set_ttl(this.pointer, ttl);
    }

    public int setMembership(String multicastAddress, String interfaceAddress, Membership membership) {
        return this._set_membership(this.pointer, multicastAddress, interfaceAddress, membership.value);
    }

    public int setMulticastLoop(boolean on) {
        return this._set_multicast_loop(this.pointer, on ? 1 : 0);
    }

    public int setMulticastTTL(int ttl) {
        return this._set_multicast_ttl(this.pointer, ttl);
    }

    public int setBroadcast(boolean on) {
        return this._set_broadcast(this.pointer, on ? 1 : 0);
    }

    private void callRecv(int nread, ByteBuffer data, Address address) {
        if (this.onRecv != null) {
            this.loop.getCallbackHandler().handleUDPRecvCallback(this.onRecv, nread, data, address);
        }
    }

    private void callSend(int status, Exception error, Object context) {
        if (this.onSend != null) {
            this.loop.getCallbackHandler(context).handleUDPSendCallback(this.onSend, status, error);
        }
    }

    private void callClose() {
        if (this.onClose != null) {
            this.loop.getCallbackHandler().handleUDPCloseCallback(this.onClose);
        }
    }

    private static native long _new(long var0);

    private static native void _static_initialize();

    private native void _initialize(long var1);

    private native Address _address(long var1);

    private native int _bind(long var1, int var3, String var4, boolean var5, int var6);

    private native int _send(long var1, ByteBuffer var3, byte[] var4, int var5, int var6, int var7, String var8, Object var9, boolean var10);

    private native int _recv_start(long var1);

    private native int _recv_stop(long var1);

    private native int _set_ttl(long var1, int var3);

    private native int _set_membership(long var1, String var3, String var4, int var5);

    private native int _set_multicast_loop(long var1, int var3);

    private native int _set_multicast_ttl(long var1, int var3);

    private native int _set_broadcast(long var1, int var3);

    private native void _close(long var1);

    static {
        UDPHandle._static_initialize();
    }

    public static enum Membership {
        LEAVE_GROUP(0),
        JOIN_GROUP(1);

        final int value;

        private Membership(int value) {
            this.value = value;
        }
    }
}

