/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

public final class S9 {
    private static final int[] bitLength = new int[]{1, 2, 3, 4, 5, 7, 9, 14, 28};
    private static final int[] codeNum = new int[]{28, 14, 9, 7, 5, 4, 3, 2, 1};

    public static int estimatecompress(int[] in, int currentPos, int inlength) {
        int tmpoutpos = 0;
        int finalpos = currentPos + inlength;
        block0: while (currentPos < finalpos) {
            int selector;
            block1: for (selector = 0; selector < 8; ++selector) {
                int compressedNum = codeNum[selector];
                if (finalpos <= currentPos + compressedNum - 1) {
                    compressedNum = finalpos - currentPos;
                }
                int b = bitLength[selector];
                int max = 1 << b;
                for (int i = 0; i < compressedNum; ++i) {
                    if (max <= in[currentPos + i]) continue block1;
                }
                currentPos += compressedNum;
                ++tmpoutpos;
                continue block0;
            }
            selector = 8;
            if (in[currentPos] >= 1 << bitLength[8]) {
                throw new RuntimeException("Too big a number");
            }
            ++tmpoutpos;
            ++currentPos;
        }
        return tmpoutpos;
    }

    protected static int compress(int[] in, int currentPos, int inlength, int[] out, int tmpoutpos) {
        int origtmpoutpos = tmpoutpos;
        int finalpos = currentPos + inlength;
        block0: while (currentPos < finalpos) {
            int selector;
            block1: for (selector = 0; selector < 8; ++selector) {
                int res = 0;
                int compressedNum = codeNum[selector];
                if (finalpos <= currentPos + compressedNum - 1) {
                    compressedNum = finalpos - currentPos;
                }
                int b = bitLength[selector];
                int max = 1 << b;
                for (int i = 0; i < compressedNum; ++i) {
                    if (max <= in[currentPos + i]) continue block1;
                    res = (res << b) + in[currentPos + i];
                }
                if (compressedNum != codeNum[selector]) {
                    res <<= (codeNum[selector] - compressedNum) * b;
                }
                out[tmpoutpos++] = res |= selector << 28;
                currentPos += compressedNum;
                continue block0;
            }
            selector = 8;
            if (in[currentPos] >= 1 << bitLength[8]) {
                throw new RuntimeException("Too big a number");
            }
            out[tmpoutpos++] = in[currentPos++] | Integer.MIN_VALUE;
        }
        return tmpoutpos - origtmpoutpos;
    }

    protected static void uncompress(int[] in, int tmpinpos, int inlength, int[] out, int currentPos, int outlength) {
        int finallength = currentPos + outlength;
        block11: while (currentPos < finallength) {
            int val = in[tmpinpos++];
            int header = val >>> 28;
            switch (header) {
                case 0: {
                    int k;
                    int howmany = finallength - currentPos < 28 ? finallength - currentPos : 28;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << k + 4 >>> 31;
                    }
                    continue block11;
                }
                case 1: {
                    int k;
                    int howmany = finallength - currentPos < 14 ? finallength - currentPos : 14;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 2 * k + 4 >>> 30;
                    }
                    continue block11;
                }
                case 2: {
                    int k;
                    int howmany = finallength - currentPos < 9 ? finallength - currentPos : 9;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 3 * k + 5 >>> 29;
                    }
                    continue block11;
                }
                case 3: {
                    int k;
                    int howmany = finallength - currentPos < 7 ? finallength - currentPos : 7;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 4 * k + 4 >>> 28;
                    }
                    continue block11;
                }
                case 4: {
                    int k;
                    int howmany = finallength - currentPos < 5 ? finallength - currentPos : 5;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 5 * k + 7 >>> 27;
                    }
                    continue block11;
                }
                case 5: {
                    int k;
                    int howmany = finallength - currentPos < 4 ? finallength - currentPos : 4;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 7 * k + 4 >>> 25;
                    }
                    continue block11;
                }
                case 6: {
                    int k;
                    int howmany = finallength - currentPos < 3 ? finallength - currentPos : 3;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 9 * k + 5 >>> 23;
                    }
                    continue block11;
                }
                case 7: {
                    int k;
                    int howmany = finallength - currentPos < 2 ? finallength - currentPos : 2;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 14 * k + 4 >>> 18;
                    }
                    continue block11;
                }
                case 8: {
                    out[currentPos++] = val << 4 >>> 4;
                    break;
                }
                default: {
                    throw new RuntimeException("shouldn't happen");
                }
            }
        }
    }
}

